/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.observation;

import EDU.oswego.cs.dl.util.concurrent.Mutex;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;

public class EventResult
implements EventListener {
    private EventIterator events;
    private Sync sync = new Mutex();
    private final PrintWriter log;

    public EventResult(PrintWriter log) {
        this.log = log;
        try {
            this.sync.acquire();
        }
        catch (InterruptedException e) {
            log.println("Could not aquire sync.");
            throw new RuntimeException("EventResult: Interrupted while aquiring sync.");
        }
    }

    public Event[] getEvents(long wait) {
        EventIterator events = this.getEventIterator(wait);
        if (events != null) {
            return this.getEvents(events);
        }
        return new Event[0];
    }

    public EventIterator getEventIterator(long wait) {
        try {
            if (this.sync.attempt(wait)) {
                return this.events;
            }
        }
        catch (InterruptedException e) {
            this.log.println("Interrupted while waiting for EventIterator");
        }
        return null;
    }

    public void onEvent(EventIterator events) {
        this.events = events;
        this.sync.release();
    }

    private Event[] getEvents(EventIterator events) {
        ArrayList<Event> eventList = new ArrayList<Event>();
        while (events.hasNext()) {
            eventList.add(events.nextEvent());
        }
        return eventList.toArray(new Event[eventList.size()]);
    }
}

