/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.test.api.version.AbstractOnParentVersionTest;

public class OnParentVersionComputeTest
extends AbstractOnParentVersionTest {
    @Override
    protected void setUp() throws Exception {
        this.OPVAction = 4;
        super.setUp();
    }

    public void testRestoreProp() throws RepositoryException {
        Node propParent = this.p.getParent();
        propParent.checkout();
        Version v = propParent.checkin();
        propParent.checkout();
        this.p.setValue(this.newPropValue);
        this.p.save();
        propParent.restore(v, false);
        OnParentVersionComputeTest.assertEquals((String)"On restore of a OnParentVersion-COMPUTE property P, the current P in the workspace will be left unchanged.", (String)this.p.getString(), (String)this.newPropValue);
    }

    public void testRestorePropJcr2() throws RepositoryException {
        Node propParent = this.p.getParent();
        VersionManager versionManager = propParent.getSession().getWorkspace().getVersionManager();
        String path = propParent.getPath();
        versionManager.checkout(path);
        Version v = versionManager.checkin(path);
        versionManager.checkout(path);
        this.p.setValue(this.newPropValue);
        this.p.getSession().save();
        versionManager.restore(v, false);
        OnParentVersionComputeTest.assertEquals((String)"On restore of a OnParentVersion-COMPUTE property P, the current P in the workspace will be left unchanged.", (String)this.p.getString(), (String)this.newPropValue);
    }
}

