/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.PropertyUtil;

abstract class AbstractPropertyTest
extends AbstractJCRTest {
    protected static String UTF8 = "UTF-8";
    protected Session session;
    protected Property prop;
    protected boolean multiple;

    AbstractPropertyTest() {
    }

    protected abstract int getPropertyType();

    protected abstract Boolean getPropertyIsMultivalued();

    @Override
    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = this.getHelper().getReadOnlySession();
        this.prop = PropertyUtil.searchProp(this.session, this.session.getRootNode().getNode(this.testPath), this.getPropertyType(), this.getPropertyIsMultivalued());
        if (this.prop == null) {
            this.cleanUp();
            String msg = "Workspace does not contain a node with a " + PropertyType.nameFromValue((int)this.getPropertyType()) + " property.";
            throw new NotExecutableException(msg);
        }
        this.multiple = this.prop.getDefinition().isMultiple();
        Value val = PropertyUtil.getValue(this.prop);
        if (val == null) {
            this.cleanUp();
            String msg = PropertyType.nameFromValue((int)this.getPropertyType()) + " property does not contain a value";
            throw new NotExecutableException(msg);
        }
    }

    @Override
    protected void cleanUp() throws Exception {
        if (this.session != null) {
            this.session.logout();
        }
        super.cleanUp();
    }

    @Override
    protected void tearDown() throws Exception {
        this.cleanUp();
        this.session = null;
        this.prop = null;
        super.tearDown();
    }
}

