/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.test.api.AbstractPropertyTest;
import org.apache.jackrabbit.test.api.PropertyUtil;

public class ReferencePropertyTest
extends AbstractPropertyTest {
    private Node referencedNode;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.referencedNode = this.prop.getNode();
    }

    @Override
    protected void tearDown() throws Exception {
        this.referencedNode = null;
        super.tearDown();
    }

    @Override
    protected int getPropertyType() {
        return 9;
    }

    @Override
    protected Boolean getPropertyIsMultivalued() {
        return Boolean.FALSE;
    }

    public void testNodeType() throws RepositoryException {
        ReferencePropertyTest.assertTrue((String)("Property " + this.prop.getName() + " refers to a node " + "which is not of NodeType mix:referenceable."), (boolean)this.referencedNode.isNodeType(this.mixReferenceable));
    }

    public void testPropValue() throws RepositoryException {
        Node referenced = this.session.getNodeByUUID(this.prop.getString());
        PropertyIterator referers = referenced.getReferences();
        if (!this.prop.isNew()) {
            boolean found = false;
            while (referers.hasNext()) {
                Property propp = referers.nextProperty();
                if (!propp.isSame((Item)this.prop)) continue;
                found = true;
            }
            ReferencePropertyTest.assertTrue((String)("Referencing property of node " + referenced.getName() + " not found."), (boolean)found);
            ReferencePropertyTest.assertTrue((String)"Referenced node retrieved with getNode is different from the node retrieved with getNodeByUUID", (boolean)referenced.isSame((Item)this.referencedNode));
        } else {
            this.log.println("Reference property " + this.prop.getName() + " is in transient state.");
        }
    }

    public void testGetBoolean() throws RepositoryException {
        try {
            Value val = PropertyUtil.getValue(this.prop);
            val.getBoolean();
            ReferencePropertyTest.fail((String)"Conversion from a Reference value to a Boolean value should throw a ValueFormatException.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetDate() throws RepositoryException {
        try {
            Value val = PropertyUtil.getValue(this.prop);
            val.getDate();
            ReferencePropertyTest.fail((String)"Conversion from a Reference value to a Date value should throw a ValueFormatException.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetDouble() throws RepositoryException {
        try {
            Value val = PropertyUtil.getValue(this.prop);
            val.getDouble();
            ReferencePropertyTest.fail((String)"Conversion from a Reference value to a Double value should throw a ValueFormatException.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetLong() throws RepositoryException {
        try {
            Value val = PropertyUtil.getValue(this.prop);
            val.getLong();
            ReferencePropertyTest.fail((String)"Conversion from a Reference value to a Long value should throw a ValueFormatException.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetString() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        val.getString();
    }

    public void testGetProperty() throws RepositoryException {
        try {
            this.prop.getProperty();
            ReferencePropertyTest.fail((String)"A REFERENCE property cannot be resolved to a Property.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetType() throws RepositoryException {
        ReferencePropertyTest.assertTrue((String)"Value.getType() returns wrong type.", (boolean)PropertyUtil.checkGetType(this.prop, 9));
    }

    public void testEquals() throws RepositoryException {
        Property prop2 = this.referencedNode.getProperty(this.jcrUUID);
        ReferencePropertyTest.assertTrue((String)"Incorrect equals method of Reference value.", (boolean)PropertyUtil.equalValues(prop2.getValue(), this.prop.getValue()));
    }
}

