/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.observation;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.apache.jackrabbit.test.api.observation.AbstractObservationTest;

public class GetIdentifierTest
extends AbstractObservationTest {
    public void testNodeAdded() throws RepositoryException {
        Event[] events = this.getEvents(new AbstractObservationTest.Callable(){

            @Override
            public void call() throws RepositoryException {
                GetIdentifierTest.this.testRootNode.addNode(GetIdentifierTest.this.nodeName1, GetIdentifierTest.this.testNodeType);
                GetIdentifierTest.this.testRootNode.getSession().save();
            }
        }, 1);
        Node n = this.testRootNode.getNode(this.nodeName1);
        GetIdentifierTest.assertEquals((String)n.getIdentifier(), (String)this.getEventByPath(events, n.getPath()).getIdentifier());
    }

    public void testNodeMoved() throws RepositoryException {
        final Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.getSession().save();
        Event[] events = this.getEvents(new AbstractObservationTest.Callable(){

            @Override
            public void call() throws RepositoryException {
                GetIdentifierTest.this.superuser.getWorkspace().move(n.getPath(), GetIdentifierTest.this.testRoot + "/" + GetIdentifierTest.this.nodeName2);
            }
        }, 32);
        String path = this.testRootNode.getNode(this.nodeName2).getPath();
        GetIdentifierTest.assertEquals((String)n.getIdentifier(), (String)this.getEventByPath(events, path).getIdentifier());
    }

    public void testNodeRemoved() throws RepositoryException {
        final Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        String path = n.getPath();
        this.testRootNode.getSession().save();
        String identifier = n.getIdentifier();
        Event[] events = this.getEvents(new AbstractObservationTest.Callable(){

            @Override
            public void call() throws RepositoryException {
                n.remove();
                GetIdentifierTest.this.testRootNode.getSession().save();
            }
        }, 2);
        GetIdentifierTest.assertEquals((String)identifier, (String)this.getEventByPath(events, path).getIdentifier());
    }

    public void testPropertyAdded() throws RepositoryException {
        Event[] events = this.getEvents(new AbstractObservationTest.Callable(){

            @Override
            public void call() throws RepositoryException {
                GetIdentifierTest.this.testRootNode.addNode(GetIdentifierTest.this.nodeName1, GetIdentifierTest.this.testNodeType).setProperty(GetIdentifierTest.this.propertyName1, "test");
                GetIdentifierTest.this.testRootNode.getSession().save();
            }
        }, 4);
        Node n = this.testRootNode.getNode(this.nodeName1);
        Property prop = n.getProperty(this.propertyName1);
        GetIdentifierTest.assertEquals((String)n.getIdentifier(), (String)this.getEventByPath(events, prop.getPath()).getIdentifier());
    }

    public void testPropertyChanged() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        final Property prop = n.setProperty(this.propertyName1, "test");
        this.testRootNode.getSession().save();
        Event[] events = this.getEvents(new AbstractObservationTest.Callable(){

            @Override
            public void call() throws RepositoryException {
                prop.setValue("modified");
                GetIdentifierTest.this.testRootNode.getSession().save();
            }
        }, 16);
        GetIdentifierTest.assertEquals((String)n.getIdentifier(), (String)this.getEventByPath(events, prop.getPath()).getIdentifier());
    }

    public void testPropertyRemoved() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        final Property prop = n.setProperty(this.propertyName1, "test");
        String propPath = prop.getPath();
        this.testRootNode.getSession().save();
        Event[] events = this.getEvents(new AbstractObservationTest.Callable(){

            @Override
            public void call() throws RepositoryException {
                prop.remove();
                GetIdentifierTest.this.testRootNode.getSession().save();
            }
        }, 8);
        GetIdentifierTest.assertEquals((String)n.getIdentifier(), (String)this.getEventByPath(events, propPath).getIdentifier());
    }
}

