/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.hierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.jackrabbit.commons.iterator.RangeIteratorAdapter;
import org.apache.jackrabbit.jcr2spi.hierarchy.ChildNodeAttic;
import org.apache.jackrabbit.jcr2spi.hierarchy.ChildNodeEntries;
import org.apache.jackrabbit.jcr2spi.hierarchy.ChildNodeEntriesImpl;
import org.apache.jackrabbit.jcr2spi.hierarchy.ChildPropertyEntries;
import org.apache.jackrabbit.jcr2spi.hierarchy.ChildPropertyEntriesImpl;
import org.apache.jackrabbit.jcr2spi.hierarchy.EntryFactory;
import org.apache.jackrabbit.jcr2spi.hierarchy.EntryValidation;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEntryImpl;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntryImpl;
import org.apache.jackrabbit.jcr2spi.operation.AddNode;
import org.apache.jackrabbit.jcr2spi.operation.AddProperty;
import org.apache.jackrabbit.jcr2spi.operation.Move;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.Remove;
import org.apache.jackrabbit.jcr2spi.operation.ReorderNodes;
import org.apache.jackrabbit.jcr2spi.operation.SetMixin;
import org.apache.jackrabbit.jcr2spi.operation.SetPrimaryType;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.PropertyState;
import org.apache.jackrabbit.jcr2spi.state.Status;
import org.apache.jackrabbit.jcr2spi.util.StateUtility;
import org.apache.jackrabbit.spi.ChildInfo;
import org.apache.jackrabbit.spi.Event;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeEntryImpl
extends HierarchyEntryImpl
implements NodeEntry {
    private static Logger log = LoggerFactory.getLogger(NodeEntryImpl.class);
    private String uniqueID;
    private final ChildNodeEntries childNodeEntries;
    private final ChildNodeAttic childNodeAttic;
    private final ChildPropertyEntries properties;
    private final Map<Name, PropertyEntry> propertiesInAttic;
    private RevertInfo revertInfo;

    private NodeEntryImpl(NodeEntryImpl parent, Name name, String uniqueID, EntryFactory factory) {
        super(parent, name, factory);
        this.uniqueID = uniqueID;
        this.properties = new ChildPropertyEntriesImpl(this, factory);
        this.childNodeEntries = new ChildNodeEntriesImpl(this, factory, null);
        this.propertiesInAttic = new HashMap<Name, PropertyEntry>();
        this.childNodeAttic = new ChildNodeAttic();
        factory.notifyEntryCreated(this);
    }

    static NodeEntry createRootEntry(EntryFactory factory) {
        return new NodeEntryImpl(null, NameConstants.ROOT, null, factory);
    }

    static NodeEntry createNodeEntry(NodeEntryImpl parent, Name name, String uniqueId, EntryFactory factory) {
        return new NodeEntryImpl(parent, name, uniqueId, factory);
    }

    @Override
    public boolean denotesNode() {
        return true;
    }

    @Override
    public void reload(boolean recursive) {
        super.reload(recursive);
        if (recursive && !Status.isTerminal(this.getStatus())) {
            Iterator<HierarchyEntry> it = this.getAllChildEntries(true);
            while (it.hasNext()) {
                HierarchyEntry ce = it.next();
                ce.reload(recursive);
            }
        }
    }

    @Override
    public void revert() throws RepositoryException {
        if (!this.propertiesInAttic.isEmpty()) {
            this.properties.addAll(this.propertiesInAttic.values());
            this.propertiesInAttic.clear();
        }
        super.revert();
    }

    @Override
    public void transientRemove() throws RepositoryException {
        Iterator<HierarchyEntry> it = this.getAllChildEntries(false);
        while (it.hasNext()) {
            HierarchyEntry ce = it.next();
            ce.transientRemove();
        }
        if (!this.propertiesInAttic.isEmpty()) {
            this.properties.addAll(this.propertiesInAttic.values());
            this.propertiesInAttic.clear();
        }
        super.transientRemove();
    }

    @Override
    public void remove() {
        super.internalRemove(false);
        boolean staleParent = this.getStatus() == 6;
        Iterator<HierarchyEntry> it = this.getAllChildEntries(true);
        while (it.hasNext()) {
            HierarchyEntryImpl ce = (HierarchyEntryImpl)it.next();
            ce.internalRemove(staleParent);
        }
    }

    @Override
    void internalRemove(boolean staleParent) {
        super.internalRemove(staleParent);
        staleParent = staleParent || this.getStatus() == 6;
        Iterator<HierarchyEntry> it = this.getAllChildEntries(true);
        while (it.hasNext()) {
            HierarchyEntryImpl ce = (HierarchyEntryImpl)it.next();
            ce.internalRemove(staleParent);
        }
    }

    @Override
    public void complete(Operation operation) throws RepositoryException {
        if (operation instanceof AddNode) {
            this.complete((AddNode)operation);
        } else if (operation instanceof AddProperty) {
            this.complete((AddProperty)operation);
        } else if (operation instanceof SetMixin) {
            this.complete((SetMixin)operation);
        } else if (operation instanceof SetPrimaryType) {
            this.complete((SetPrimaryType)operation);
        } else if (operation instanceof Remove) {
            this.complete((Remove)operation);
        } else if (operation instanceof ReorderNodes) {
            this.complete((ReorderNodes)operation);
        } else if (operation instanceof Move) {
            this.complete((Move)operation);
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public NodeId getId() throws InvalidItemStateException, RepositoryException {
        return this.getId(false);
    }

    @Override
    public NodeId getWorkspaceId() throws InvalidItemStateException, RepositoryException {
        return this.getId(true);
    }

    private NodeId getId(boolean wspId) throws RepositoryException {
        if (this.parent == null) {
            return this.getIdFactory().createNodeId((String)null, this.getPathFactory().getRootPath());
        }
        if (this.uniqueID != null) {
            return this.getIdFactory().createNodeId(this.uniqueID);
        }
        return NodeEntryImpl.buildNodeId(this, this.getPathFactory(), this.getIdFactory(), wspId);
    }

    private static NodeId buildNodeId(NodeEntryImpl entry, PathFactory pathFactory, IdFactory idFactory, boolean wspId) throws RepositoryException {
        PathBuilder pathBuilder = new PathBuilder(pathFactory);
        while (entry.getParent() != null && entry.getUniqueID() == null) {
            pathBuilder.addFirst(entry.getName(wspId), entry.getIndex(wspId));
            entry = wspId && entry.revertInfo != null ? entry.revertInfo.oldParent : entry.parent;
        }
        if (entry.getParent() == null) {
            pathBuilder.addRoot();
            return idFactory.createNodeId((String)null, pathBuilder.getPath());
        }
        return idFactory.createNodeId(entry.getUniqueID(), pathBuilder.getPath());
    }

    @Override
    public String getUniqueID() {
        return this.uniqueID;
    }

    @Override
    public void setUniqueID(String uniqueID) {
        boolean mod;
        String old = this.uniqueID;
        boolean bl = uniqueID == null ? old != null : (mod = !uniqueID.equals(old));
        if (mod) {
            this.uniqueID = uniqueID;
            this.factory.notifyIdChange(this, old);
        }
    }

    @Override
    public int getIndex() throws InvalidItemStateException, RepositoryException {
        return this.getIndex(false);
    }

    @Override
    public NodeState getNodeState() throws ItemNotFoundException, RepositoryException {
        return (NodeState)this.getItemState();
    }

    @Override
    public NodeEntry getDeepNodeEntry(Path path) throws PathNotFoundException, RepositoryException {
        NodeEntryImpl entry = this;
        Path.Element[] elems = path.getElements();
        for (int i = 0; i < elems.length; ++i) {
            Path.Element elem = elems[i];
            if (elem.denotesRoot()) {
                if (entry.getParent() == null) continue;
                throw new RepositoryException("NodeEntry out of 'hierarchy' " + path.toString());
            }
            int index = elem.getNormalizedIndex();
            Name name = elem.getName();
            NodeEntry cne = entry.getNodeEntry(name, index, false);
            if (cne != null) {
                entry = (NodeEntryImpl)cne;
                continue;
            }
            if (entry.childNodeEntries.isComplete()) {
                throw new PathNotFoundException(this.factory.saveGetJCRPath(path));
            }
            List<NodeEntry> siblings = entry.childNodeEntries.get(name);
            if (entry.containsAtticChild(siblings, name, index)) {
                throw new PathNotFoundException(this.factory.saveGetJCRPath(path));
            }
            if (entry.getStatus() == 4) {
                throw new PathNotFoundException(this.factory.saveGetJCRPath(path));
            }
            PathBuilder pb = new PathBuilder(this.getPathFactory());
            for (int j = i; j < elems.length; ++j) {
                pb.addLast(elems[j]);
            }
            Path remainingPath = pb.getPath();
            NodeId parentId = entry.getWorkspaceId();
            IdFactory idFactory = this.factory.getIdFactory();
            NodeId nodeId = idFactory.createNodeId(parentId, remainingPath);
            NodeEntry ne = entry.loadNodeEntry(nodeId);
            if (ne != null) {
                return ne;
            }
            throw new PathNotFoundException(this.factory.saveGetJCRPath(path));
        }
        return entry;
    }

    @Override
    public PropertyEntry getDeepPropertyEntry(Path path) throws PathNotFoundException, RepositoryException {
        PropertyEntry pe;
        int i;
        NodeEntryImpl entry = this;
        Path.Element[] elems = path.getElements();
        for (i = 0; i < elems.length - 1; ++i) {
            Path.Element elem = elems[i];
            if (elems[i].denotesRoot()) {
                if (entry.getParent() == null) continue;
                throw new RepositoryException("NodeEntry out of 'hierarchy' " + path.toString());
            }
            int index = elem.getNormalizedIndex();
            Name name = elem.getName();
            NodeEntry cne = entry.getNodeEntry(name, index, false);
            if (cne != null) {
                entry = (NodeEntryImpl)cne;
                continue;
            }
            if (entry.childNodeEntries.isComplete()) {
                throw new PathNotFoundException(this.factory.saveGetJCRPath(path));
            }
            List<NodeEntry> siblings = entry.childNodeEntries.get(name);
            if (!entry.containsAtticChild(siblings, name, index)) break;
            throw new PathNotFoundException(this.factory.saveGetJCRPath(path));
        }
        int st = entry.getStatus();
        if (i == elems.length - 1 && 0 != st && -1 != st) {
            pe = entry.properties.get(path.getName());
        } else {
            PathBuilder pb = new PathBuilder(this.getPathFactory());
            for (int j = i; j < elems.length; ++j) {
                pb.addLast(elems[j]);
            }
            Path remainingPath = pb.getPath();
            IdFactory idFactory = this.getIdFactory();
            NodeId parentId = entry.getWorkspaceId();
            if (remainingPath.getLength() != 1) {
                parentId = idFactory.createNodeId(parentId, remainingPath.getAncestor(1));
            }
            PropertyId propId = idFactory.createPropertyId(parentId, remainingPath.getName());
            pe = entry.loadPropertyEntry(propId);
        }
        if (pe == null) {
            throw new PathNotFoundException(this.factory.saveGetJCRPath(path));
        }
        return pe;
    }

    @Override
    public HierarchyEntry lookupDeepEntry(Path workspacePath) {
        NodeEntryImpl entry = this;
        for (int i = 0; i < workspacePath.getLength(); ++i) {
            Path.Element elem = workspacePath.getElements()[i];
            if (elem.denotesRoot()) {
                if (this.getParent() == null) continue;
                log.warn("NodeEntry out of 'hierarchy'" + workspacePath.toString());
                return null;
            }
            int index = elem.getNormalizedIndex();
            Name childName = elem.getName();
            NodeEntry cne = entry.lookupNodeEntry(null, childName, index);
            if (cne != null) {
                entry = (NodeEntryImpl)cne;
                continue;
            }
            if (index == 1 && i == workspacePath.getLength() - 1) {
                return entry.lookupPropertyEntry(childName);
            }
            return null;
        }
        return entry;
    }

    @Override
    public synchronized boolean hasNodeEntry(Name nodeName) {
        List<NodeEntry> namedEntries = this.childNodeEntries.get(nodeName);
        if (namedEntries.isEmpty()) {
            return false;
        }
        return EntryValidation.containsValidNodeEntry(namedEntries.iterator());
    }

    @Override
    public synchronized boolean hasNodeEntry(Name nodeName, int index) {
        try {
            return this.getNodeEntry(nodeName, index) != null;
        }
        catch (RepositoryException e) {
            log.debug("Unable to determine if a child node with name " + nodeName + " exists.");
            return false;
        }
    }

    @Override
    public synchronized NodeEntry getNodeEntry(Name nodeName, int index) throws RepositoryException {
        return this.getNodeEntry(nodeName, index, false);
    }

    @Override
    public NodeEntry getNodeEntry(Name nodeName, int index, boolean loadIfNotFound) throws RepositoryException {
        List<NodeEntry> entries = this.childNodeEntries.get(nodeName);
        NodeEntry cne = null;
        if (entries.size() >= index) {
            int eIndex = 1;
            for (int i = 0; i < entries.size() && cne == null; ++i) {
                NodeEntry ne = entries.get(i);
                if (!EntryValidation.isValidNodeEntry(ne)) continue;
                if (eIndex == index) {
                    cne = ne;
                }
                ++eIndex;
            }
        }
        if (cne == null && loadIfNotFound && !this.containsAtticChild(entries, nodeName, index) && !this.childNodeEntries.isComplete()) {
            NodeId cId = this.getIdFactory().createNodeId(this.getWorkspaceId(), this.getPathFactory().create(nodeName, index));
            cne = this.loadNodeEntry(cId);
        }
        return cne;
    }

    @Override
    public synchronized Iterator<NodeEntry> getNodeEntries() throws RepositoryException {
        ArrayList<NodeEntry> entries = new ArrayList<NodeEntry>();
        Iterator<NodeEntry> it = this.getCompleteChildNodeEntries().iterator();
        while (it.hasNext()) {
            NodeEntry entry = it.next();
            if (!EntryValidation.isValidNodeEntry(entry)) continue;
            entries.add(entry);
        }
        return new RangeIteratorAdapter(Collections.unmodifiableCollection(entries));
    }

    @Override
    public synchronized List<NodeEntry> getNodeEntries(Name nodeName) throws RepositoryException {
        List<NodeEntry> namedEntries = this.getCompleteChildNodeEntries().get(nodeName);
        if (namedEntries.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NodeEntry> entries = new ArrayList<NodeEntry>();
        NodeEntry[] arr = namedEntries.toArray(new NodeEntry[namedEntries.size()]);
        for (int i = 0; i < arr.length; ++i) {
            NodeEntry cne = arr[i];
            if (!EntryValidation.isValidNodeEntry(cne)) continue;
            entries.add(cne);
        }
        return Collections.unmodifiableList(entries);
    }

    @Override
    public void setNodeEntries(Iterator<ChildInfo> childInfos) throws RepositoryException {
        if (this.childNodeAttic.isEmpty()) {
            ((ChildNodeEntriesImpl)this.childNodeEntries).update(childInfos);
        } else {
            ArrayList<ChildInfo> remaining = new ArrayList<ChildInfo>();
            while (childInfos.hasNext()) {
                ChildInfo ci = childInfos.next();
                if (this.childNodeAttic.contains(ci.getName(), ci.getIndex(), ci.getUniqueID())) continue;
                remaining.add(ci);
            }
            ((ChildNodeEntriesImpl)this.childNodeEntries).update(remaining.iterator());
        }
    }

    @Override
    public NodeEntry getOrAddNodeEntry(Name nodeName, int index, String uniqueID) throws RepositoryException {
        NodeEntry ne = this.lookupNodeEntry(uniqueID, nodeName, index);
        if (ne == null) {
            ne = this.internalAddNodeEntry(nodeName, uniqueID, index);
        } else {
            log.debug("Child NodeEntry already exists -> didn't add.");
        }
        return ne;
    }

    @Override
    public NodeEntry addNewNodeEntry(Name nodeName, String uniqueID, Name primaryNodeType, QNodeDefinition definition) throws RepositoryException {
        NodeEntry entry = this.internalAddNodeEntry(nodeName, uniqueID, 0);
        NodeState state = this.getItemStateFactory().createNewNodeState(entry, primaryNodeType, definition);
        entry.setItemState(state);
        return entry;
    }

    @Override
    public synchronized boolean hasPropertyEntry(Name propName) {
        PropertyEntry entry = this.properties.get(propName);
        return EntryValidation.isValidPropertyEntry(entry);
    }

    @Override
    public synchronized PropertyEntry getPropertyEntry(Name propName) {
        PropertyEntry entry = this.properties.get(propName);
        if (EntryValidation.isValidPropertyEntry(entry)) {
            return entry;
        }
        return null;
    }

    @Override
    public PropertyEntry getPropertyEntry(Name propName, boolean loadIfNotFound) throws RepositoryException {
        return this.getPropertyEntry(propName);
    }

    @Override
    public synchronized Iterator<PropertyEntry> getPropertyEntries() {
        Collection<Object> props;
        if (this.getStatus() == 2) {
            props = new ArrayList();
            Object[] arr = this.properties.getPropertyEntries().toArray();
            for (int i = 0; i < arr.length; ++i) {
                PropertyEntry propEntry = (PropertyEntry)arr[i];
                if (!EntryValidation.isValidPropertyEntry(propEntry)) continue;
                props.add(propEntry);
            }
        } else {
            props = this.properties.getPropertyEntries();
        }
        return new RangeIteratorAdapter(Collections.unmodifiableCollection(props));
    }

    @Override
    public PropertyEntry getOrAddPropertyEntry(Name propName) throws ItemExistsException {
        PropertyEntry pe = this.lookupPropertyEntry(propName);
        if (pe == null) {
            pe = this.internalAddPropertyEntry(propName, true);
        } else {
            log.debug("Child PropertyEntry already exists -> didn't add.");
        }
        return pe;
    }

    @Override
    public void setPropertyEntries(Collection<Name> propNames) throws ItemExistsException, RepositoryException {
        HashSet<Name> diff = new HashSet<Name>();
        diff.addAll(this.properties.getPropertyNames());
        boolean containsExtra = diff.removeAll(propNames);
        for (Name propName : propNames) {
            if (this.properties.contains(propName)) continue;
            this.internalAddPropertyEntry(propName, false);
        }
        ItemState state = this.internalGetItemState();
        if (containsExtra && (state == null || state.getStatus() == 0)) {
            for (Name propName : diff) {
                PropertyEntry pEntry = this.properties.get(propName);
                if (pEntry == null) continue;
                pEntry.remove();
            }
        }
    }

    @Override
    public PropertyEntry addNewPropertyEntry(Name propName, QPropertyDefinition definition, QValue[] values, int propertyType) throws ItemExistsException, RepositoryException {
        block6: {
            PropertyEntry existing = this.properties.get(propName);
            if (existing != null) {
                try {
                    PropertyState existingState = existing.getPropertyState();
                    int status = existingState.getStatus();
                    if (Status.isTerminal(status)) {
                        this.properties.remove(existing);
                        break block6;
                    }
                    if (status == 3) {
                        this.propertiesInAttic.put(propName, existing);
                        break block6;
                    }
                    throw new ItemExistsException(propName.toString());
                }
                catch (ItemNotFoundException e) {
                    this.properties.remove(existing);
                }
                catch (RepositoryException e) {
                    this.properties.remove(existing);
                }
            }
        }
        PropertyEntry entry = this.factory.createPropertyEntry(this, propName);
        PropertyState state = this.getItemStateFactory().createNewPropertyState(entry, definition, values, propertyType);
        entry.setItemState(state);
        this.properties.add(entry);
        return entry;
    }

    @Override
    public void orderBefore(NodeEntry beforeEntry) throws RepositoryException {
        if (4 == this.getStatus()) {
            this.parent.childNodeEntries.reorder(this, beforeEntry);
        } else {
            this.createRevertInfo();
            this.parent.childNodeEntries.reorder(this, beforeEntry);
        }
    }

    @Override
    public NodeEntry move(Name newName, NodeEntry newParent, boolean transientMove) throws RepositoryException {
        NodeEntry entry;
        if (this.parent == null) {
            throw new RepositoryException("Root cannot be moved.");
        }
        if (transientMove) {
            this.createRevertInfo();
            if (4 != this.getStatus()) {
                if (newParent != this.revertInfo.oldParent) {
                    ((RevertInfo)this.revertInfo).oldParent.childNodeAttic.add(this);
                } else {
                    ((RevertInfo)this.revertInfo).oldParent.childNodeAttic.remove(this);
                }
            }
        }
        if ((entry = this.parent.childNodeEntries.remove(this)) != this) {
            String msg = "Internal error. Attempt to move NodeEntry (" + this.getName() + ") which is not connected to its parent.";
            log.error(msg);
            throw new RepositoryException(msg);
        }
        this.parent = (NodeEntryImpl)newParent;
        this.name = newName;
        this.parent.childNodeEntries.add(this);
        return this;
    }

    @Override
    public boolean isTransientlyMoved() {
        return this.revertInfo != null && this.revertInfo.isMoved();
    }

    @Override
    public void refresh(Event childEvent) {
        ItemId eventId = childEvent.getItemId();
        Path eventPath = childEvent.getPath();
        Name eventName = eventPath.getName();
        HierarchyEntry child = this.lookupEntry(eventId, eventPath);
        switch (childEvent.getType()) {
            case 1: 
            case 4: {
                if (child == null || child.getStatus() == 8) {
                    if (childEvent.getType() == 1) {
                        String uniqueChildID = eventId.getPath() == null ? eventId.getUniqueID() : null;
                        int index = eventPath.getNormalizedIndex();
                        this.internalAddNodeEntry(eventName, uniqueChildID, index);
                        break;
                    }
                    this.internalAddPropertyEntry(eventName, true);
                    break;
                }
                int status = child.getStatus();
                if (4 != status) break;
                this.internalGetItemState().setStatus(7);
                break;
            }
            case 2: 
            case 8: {
                if (child == null) break;
                int status = child.getStatus();
                if (3 == status) {
                    this.internalGetItemState().setStatus(7);
                }
                child.remove();
                break;
            }
            case 16: {
                int status;
                if (child == null) {
                    this.internalAddPropertyEntry(eventName, true);
                    break;
                }
                if (!child.isAvailable() || Status.isStale(status = child.getStatus())) break;
                if (Status.isTransient(child.getStatus())) {
                    ((HierarchyEntryImpl)child).internalGetItemState().setStatus(7);
                    break;
                }
                child.invalidate(false);
                if (!StateUtility.isUuidOrMixin(eventName)) break;
                this.notifyUUIDorMIXINModified((PropertyEntry)child);
                break;
            }
            case 32: {
                throw new UnsupportedOperationException("Implementation missing");
            }
            case 64: {
                throw new UnsupportedOperationException("Implementation missing");
            }
            default: {
                throw new IllegalArgumentException("Illegal event type " + childEvent.getType() + " for NodeState.");
            }
        }
    }

    @Override
    ItemState doResolve() throws ItemNotFoundException, RepositoryException {
        return this.getItemStateFactory().createNodeState(this.getWorkspaceId(), this);
    }

    @Override
    Path buildPath(boolean wspPath) throws RepositoryException {
        PathFactory pf = this.getPathFactory();
        if (this.parent == null) {
            return pf.getRootPath();
        }
        PathBuilder builder = new PathBuilder(pf);
        NodeEntryImpl.buildPath(builder, this, wspPath);
        return builder.getPath();
    }

    private static void buildPath(PathBuilder builder, NodeEntryImpl nEntry, boolean wspPath) throws RepositoryException {
        NodeEntryImpl parentEntry;
        NodeEntryImpl nodeEntryImpl = parentEntry = wspPath && nEntry.revertInfo != null ? nEntry.revertInfo.oldParent : nEntry.parent;
        if (parentEntry == null) {
            builder.addRoot();
            return;
        }
        NodeEntryImpl.buildPath(builder, parentEntry, wspPath);
        int index = nEntry.getIndex(wspPath);
        Name name = nEntry.getName(wspPath);
        builder.addLast(name, index);
    }

    private NodeEntry internalAddNodeEntry(Name nodeName, String uniqueID, int index) {
        NodeEntry entry = this.factory.createNodeEntry(this, nodeName, uniqueID);
        this.childNodeEntries.add(entry, index);
        return entry;
    }

    private PropertyEntry internalAddPropertyEntry(Name propName, boolean notifySpecial) {
        PropertyEntry entry = this.factory.createPropertyEntry(this, propName);
        this.properties.add(entry);
        if (notifySpecial && StateUtility.isUuidOrMixin(propName)) {
            this.notifyUUIDorMIXINModified(entry);
        }
        return entry;
    }

    void internalRemoveChildEntry(HierarchyEntry childEntry) {
        if (childEntry.denotesNode()) {
            if (this.childNodeEntries.remove((NodeEntry)childEntry) == null) {
                this.childNodeAttic.remove((NodeEntry)childEntry);
            }
        } else {
            Name propName = childEntry.getName();
            PropertyEntry atticEntry = this.propertiesInAttic.get(propName);
            if (atticEntry == null) {
                this.properties.remove((PropertyEntry)childEntry);
            } else if (atticEntry == childEntry) {
                this.propertiesInAttic.remove(propName);
            }
            if (StateUtility.isUuidOrMixin(propName)) {
                this.notifyUUIDorMIXINRemoved(propName);
            }
        }
    }

    @Override
    protected void invalidateInternal(boolean recursive) {
        if (recursive) {
            Iterator<HierarchyEntry> it = this.getAllChildEntries(true);
            while (it.hasNext()) {
                HierarchyEntry ce = it.next();
                ce.invalidate(true);
            }
        }
        super.invalidateInternal(true);
    }

    boolean matches(Name oldName, int oldIndex) {
        try {
            return this.getName(true).equals(oldName) && this.getIndex(true) == oldIndex;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    boolean matches(Name oldName) {
        return this.getName(true).equals(oldName);
    }

    private Name getName(boolean wspName) {
        if (wspName && this.revertInfo != null) {
            return this.revertInfo.oldName;
        }
        return this.name;
    }

    private int getIndex(boolean wspIndex) throws InvalidItemStateException, RepositoryException {
        if (this.parent == null) {
            return 1;
        }
        if (wspIndex && this.revertInfo != null) {
            return this.revertInfo.oldIndex;
        }
        NodeState state = (NodeState)this.internalGetItemState();
        if (state == null || !state.hasDefinition() || state.getDefinition().allowsSameNameSiblings()) {
            return this.parent.getChildIndex(this, wspIndex);
        }
        return 1;
    }

    private NodeEntry loadNodeEntry(NodeId childId) throws RepositoryException {
        try {
            NodeState state = this.getItemStateFactory().createDeepNodeState(childId, this);
            return state.getNodeEntry();
        }
        catch (ItemNotFoundException e) {
            return null;
        }
    }

    private PropertyEntry loadPropertyEntry(PropertyId childId) throws RepositoryException {
        try {
            PropertyState state = this.getItemStateFactory().createDeepPropertyState(childId, this);
            return (PropertyEntry)state.getHierarchyEntry();
        }
        catch (ItemNotFoundException e) {
            return null;
        }
    }

    private HierarchyEntry lookupEntry(ItemId eventId, Path eventPath) {
        HierarchyEntry child;
        Name childName = eventPath.getName();
        if (eventId.denotesNode()) {
            String uniqueChildID = eventId.getPath() == null ? eventId.getUniqueID() : null;
            int index = eventPath.getNormalizedIndex();
            child = this.lookupNodeEntry(uniqueChildID, childName, index);
        } else {
            child = this.lookupPropertyEntry(childName);
        }
        return child;
    }

    private NodeEntry lookupNodeEntry(String uniqueChildId, Name childName, int index) {
        NodeEntry child = null;
        if (uniqueChildId != null && (child = this.childNodeAttic.get(uniqueChildId)) == null) {
            child = this.childNodeEntries.get(childName, uniqueChildId);
        }
        if (child == null && (child = this.childNodeAttic.get(childName, index)) == null && this.childNodeEntries != null) {
            child = this.childNodeEntries.get(childName, index);
        }
        return child;
    }

    private PropertyEntry lookupPropertyEntry(Name childName) {
        PropertyEntry child = this.propertiesInAttic.get(childName);
        if (child == null) {
            child = this.properties.get(childName);
        }
        return child;
    }

    private void notifyUUIDorMIXINModified(PropertyEntry child) {
        try {
            NodeState state;
            if (NameConstants.JCR_UUID.equals(child.getName())) {
                PropertyState ps = child.getPropertyState();
                this.setUniqueID(ps.getValue().getString());
            } else if (NameConstants.JCR_MIXINTYPES.equals(child.getName()) && (state = (NodeState)this.internalGetItemState()) != null) {
                PropertyState ps = child.getPropertyState();
                state.setMixinTypeNames(StateUtility.getMixinNames(ps));
            }
        }
        catch (ItemNotFoundException e) {
            log.debug("Property with name " + child.getName() + " does not exist (anymore)");
        }
        catch (RepositoryException e) {
            log.debug("Unable to access child property " + child.getName(), (Object)e.getMessage());
        }
    }

    private void notifyUUIDorMIXINRemoved(Name propName) {
        NodeState state;
        if (NameConstants.JCR_UUID.equals(propName)) {
            this.setUniqueID(null);
        } else if (NameConstants.JCR_MIXINTYPES.equals(propName) && (state = (NodeState)this.internalGetItemState()) != null) {
            state.setMixinTypeNames(Name.EMPTY_ARRAY);
        }
    }

    private ChildNodeEntries getCompleteChildNodeEntries() throws InvalidItemStateException, RepositoryException {
        try {
            this.childNodeEntries.reload();
        }
        catch (ItemNotFoundException e) {
            log.debug("NodeEntry does not exist (anymore) -> remove.");
            this.remove();
            throw new InvalidItemStateException((Throwable)e);
        }
        return this.childNodeEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<HierarchyEntry> getAllChildEntries(boolean includeAttic) {
        IteratorChain chain = new IteratorChain();
        if (includeAttic) {
            Collection<PropertyEntry> attic = this.propertiesInAttic.values();
            chain.addIterator(new ArrayList<PropertyEntry>(attic).iterator());
        }
        Object object = this.properties;
        synchronized (object) {
            Collection<PropertyEntry> props = this.properties.getPropertyEntries();
            chain.addIterator(props.iterator());
        }
        object = this.childNodeEntries;
        synchronized (object) {
            chain.addIterator(this.childNodeEntries.iterator());
        }
        return chain;
    }

    private int getChildIndex(NodeEntry cne, boolean wspIndex) throws ItemNotFoundException, RepositoryException {
        ArrayList<NodeEntry> sns = new ArrayList<NodeEntry>(this.childNodeEntries.get(cne.getName()));
        if (wspIndex) {
            List<NodeEntryImpl> atticSiblings = this.childNodeAttic.get(cne.getName());
            for (NodeEntryImpl sibl : atticSiblings) {
                if (sibl.revertInfo != null) {
                    sns.add(sibl.revertInfo.oldIndex - 1, sibl);
                    continue;
                }
                log.error("Sibling in attic doesn't have revertInfo....");
            }
        }
        if (sns.isEmpty()) {
            String msg = "NodeEntry " + cne.getName() + " is disconnected from its parent -> remove.";
            cne.remove();
            throw new InvalidItemStateException(msg);
        }
        if (sns.size() == 1) {
            return 1;
        }
        int index = 1;
        for (NodeEntry entry : sns) {
            if (entry == cne) {
                return index;
            }
            boolean isValid = wspIndex ? EntryValidation.isValidWorkspaceNodeEntry(entry) : EntryValidation.isValidNodeEntry(entry);
            if (!isValid) continue;
            ++index;
        }
        return 1;
    }

    private boolean containsAtticChild(List<NodeEntry> siblings, Name childName, int childIndex) {
        if (this.childNodeAttic.contains(childName, childIndex)) {
            return true;
        }
        if (childIndex > 1) {
            List<NodeEntryImpl> siblingsInAttic = this.childNodeAttic.get(childName);
            if (siblings.size() < childIndex && childIndex <= siblings.size() + siblingsInAttic.size()) {
                return true;
            }
        }
        if (this.getStatus() == 2) {
            for (NodeEntry child : siblings) {
                if (EntryValidation.isValidNodeEntry(child) && (((NodeEntryImpl)child).revertInfo == null || ((NodeEntryImpl)child).revertInfo.oldIndex != childIndex)) continue;
                return true;
            }
        }
        return false;
    }

    private void createRevertInfo() throws RepositoryException {
        if (this.revertInfo == null && this.getStatus() != 4) {
            this.revertInfo = new RevertInfo();
        }
    }

    private void complete(AddNode operation) throws RepositoryException {
        if (operation.getParentState().getHierarchyEntry() != this) {
            throw new IllegalArgumentException();
        }
        Iterator<ItemState> it = operation.getAddedStates().iterator();
        while (it.hasNext()) {
            HierarchyEntry he = it.next().getHierarchyEntry();
            if (he.getStatus() != 4) continue;
            switch (operation.getStatus()) {
                case 1: {
                    ((HierarchyEntryImpl)he).internalGetItemState().setStatus(1);
                    he.invalidate(false);
                    break;
                }
                case 2: {
                    he.revert();
                    break;
                }
            }
        }
    }

    private void complete(AddProperty operation) throws RepositoryException {
        if (operation.getParentState().getHierarchyEntry() != this) {
            throw new IllegalArgumentException();
        }
        PropertyEntry pe = this.getPropertyEntry(operation.getPropertyName());
        if (pe != null && pe.getStatus() == 4) {
            switch (operation.getStatus()) {
                case 1: {
                    PropertyState addedState = (PropertyState)((PropertyEntryImpl)pe).internalGetItemState();
                    addedState.setStatus(1);
                    QPropertyDefinition pd = addedState.getDefinition();
                    if (!pd.isAutoCreated() && !pd.isProtected()) break;
                    pe.invalidate(true);
                    break;
                }
                case 2: {
                    pe.revert();
                    break;
                }
            }
        }
    }

    private void complete(Remove operation) throws RepositoryException {
        HierarchyEntry rmEntry = operation.getRemoveState().getHierarchyEntry();
        if (rmEntry.getParent() != this) {
            throw new IllegalArgumentException();
        }
        switch (operation.getStatus()) {
            case 1: {
                if (Status.isTerminal(rmEntry.getStatus())) {
                    log.debug("Removal of State " + rmEntry + " has already been completed.");
                }
                rmEntry.remove();
                break;
            }
            case 2: {
                Name propName;
                if (!rmEntry.denotesNode() && this.propertiesInAttic.containsKey(propName = rmEntry.getName())) {
                    this.properties.add(this.propertiesInAttic.remove(propName));
                }
                rmEntry.revert();
                break;
            }
        }
    }

    private void complete(SetMixin operation) throws RepositoryException {
        if (operation.getNodeState().getHierarchyEntry() != this) {
            throw new IllegalArgumentException();
        }
        PropertyEntry pe = this.getPropertyEntry(NameConstants.JCR_MIXINTYPES);
        if (pe != null) {
            PropertyState pState = pe.getPropertyState();
            switch (operation.getStatus()) {
                case 1: {
                    Name[] mixins = StateUtility.getMixinNames(pState);
                    this.getNodeState().setMixinTypeNames(mixins);
                    if (pState.getStatus() != 4 && pState.getStatus() != 2) break;
                    pState.setStatus(1);
                    break;
                }
                case 2: {
                    pe.revert();
                    break;
                }
            }
        }
    }

    private void complete(SetPrimaryType operation) throws RepositoryException {
        if (operation.getNodeState().getHierarchyEntry() != this) {
            throw new IllegalArgumentException();
        }
        PropertyEntry pe = this.getPropertyEntry(NameConstants.JCR_PRIMARYTYPE);
        if (pe != null) {
            PropertyState pState = pe.getPropertyState();
            switch (operation.getStatus()) {
                case 1: {
                    if (pState.getStatus() != 4 && pState.getStatus() != 2) break;
                    pState.setStatus(1);
                    break;
                }
                case 2: {
                    pe.revert();
                    break;
                }
            }
        }
    }

    private void complete(ReorderNodes operation) throws RepositoryException {
        HierarchyEntry he = operation.getInsertNode().getHierarchyEntry();
        if (he != this) {
            throw new IllegalArgumentException();
        }
        switch (operation.getStatus()) {
            case 1: {
                if (this.revertInfo == null || this.revertInfo.isMoved()) break;
                this.revertInfo.dispose(true);
                break;
            }
            case 2: {
                if (he.getStatus() == 4) {
                    he.revert();
                    break;
                }
                if (this.revertInfo == null || this.revertInfo.isMoved()) break;
                this.revertInfo.dispose(false);
                break;
            }
        }
    }

    private void complete(Move operation) throws RepositoryException {
        HierarchyEntry he = operation.getSourceState().getHierarchyEntry();
        if (he != this) {
            throw new IllegalArgumentException();
        }
        switch (operation.getStatus()) {
            case 1: {
                if (this.getStatus() == 4 || this.revertInfo == null) break;
                ((RevertInfo)this.revertInfo).oldParent.childNodeAttic.remove(this);
                this.revertInfo.dispose(true);
                break;
            }
            case 2: {
                if (this.getStatus() == 4) {
                    this.revert();
                    break;
                }
                if (this.revertInfo == null) break;
                this.revertMove();
                this.revertInfo.dispose(false);
                break;
            }
        }
    }

    private void revertMove() {
        NodeEntryImpl oldParent = this.revertInfo.oldParent;
        if (oldParent == this.parent) {
            this.parent.childNodeEntries.remove(this);
        } else {
            this.parent.childNodeEntries.remove(this);
            oldParent.childNodeAttic.remove(this);
            this.parent = oldParent;
        }
        this.name = this.revertInfo.oldName;
        this.parent.childNodeEntries.add(this, this.revertInfo.oldIndex, this.revertInfo.oldSuccessor);
    }

    private class RevertInfo {
        private final NodeEntryImpl oldParent;
        private final Name oldName;
        private final int oldIndex;
        private final NodeEntry oldSuccessor;
        private final NodeEntry oldPredecessor;

        private RevertInfo() throws InvalidItemStateException, RepositoryException {
            this.oldParent = NodeEntryImpl.this.parent;
            this.oldName = NodeEntryImpl.this.name;
            this.oldIndex = NodeEntryImpl.this.getIndex();
            this.oldSuccessor = ((ChildNodeEntriesImpl)NodeEntryImpl.this.parent.childNodeEntries).getNext(NodeEntryImpl.this);
            this.oldPredecessor = ((ChildNodeEntriesImpl)NodeEntryImpl.this.parent.childNodeEntries).getPrevious(NodeEntryImpl.this);
        }

        private boolean isMoved() {
            return this.oldParent != NodeEntryImpl.this.getParent() || !NodeEntryImpl.this.getName().equals(this.oldName);
        }

        private void dispose(boolean persisted) {
            if (!persisted) {
                NodeEntryImpl ne = NodeEntryImpl.this;
                ChildNodeEntriesImpl parentCNEs = (ChildNodeEntriesImpl)NodeEntryImpl.this.parent.childNodeEntries;
                parentCNEs.reorderAfter(ne, ((NodeEntryImpl)NodeEntryImpl.this).revertInfo.oldPredecessor);
                try {
                    if (this.oldIndex != ne.getIndex()) {
                        log.warn("Reverting didn't restore the correct index.");
                    }
                }
                catch (RepositoryException e) {
                    log.warn("Unable to calculate index.", (Object)e.getMessage());
                }
            }
            NodeEntryImpl.this.revertInfo = null;
        }
    }
}

