/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProvider;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EffectiveNodeTypeImpl
implements Cloneable,
EffectiveNodeType {
    private static Logger log = LoggerFactory.getLogger(EffectiveNodeTypeImpl.class);
    private final TreeSet<Name> mergedNodeTypes = new TreeSet();
    private final TreeSet<Name> inheritedNodeTypes = new TreeSet();
    private final TreeSet<Name> allNodeTypes = new TreeSet();
    private final Map<Name, List<QItemDefinition>> namedItemDefs = new HashMap<Name, List<QItemDefinition>>();
    private final List<QItemDefinition> unnamedItemDefs = new ArrayList<QItemDefinition>();
    private Set<Name> supportedMixins;

    EffectiveNodeTypeImpl(TreeSet<Name> mergedNodeTypes, TreeSet<Name> inheritedNodeTypes, TreeSet<Name> allNodeTypes, Map<Name, List<QItemDefinition>> namedItemDefs, List<QItemDefinition> unnamedItemDefs, Set<Name> supportedMixins) {
        this.mergedNodeTypes.addAll(mergedNodeTypes);
        this.inheritedNodeTypes.addAll(inheritedNodeTypes);
        this.allNodeTypes.addAll(allNodeTypes);
        for (Map.Entry<Name, List<QItemDefinition>> entry : namedItemDefs.entrySet()) {
            this.namedItemDefs.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        this.unnamedItemDefs.addAll(unnamedItemDefs);
        if (supportedMixins != null) {
            this.supportedMixins = new HashSet<Name>();
            this.supportedMixins.addAll(supportedMixins);
        }
    }

    @Override
    public Name[] getInheritedNodeTypes() {
        return this.inheritedNodeTypes.toArray(new Name[this.inheritedNodeTypes.size()]);
    }

    @Override
    public Name[] getAllNodeTypes() {
        return this.allNodeTypes.toArray(new Name[this.allNodeTypes.size()]);
    }

    @Override
    public Name[] getMergedNodeTypes() {
        return this.mergedNodeTypes.toArray(new Name[this.mergedNodeTypes.size()]);
    }

    @Override
    public QNodeDefinition[] getAllQNodeDefinitions() {
        if (this.namedItemDefs.size() == 0 && this.unnamedItemDefs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        ArrayList<QItemDefinition> defs = new ArrayList<QItemDefinition>(this.namedItemDefs.size() + this.unnamedItemDefs.size());
        for (QItemDefinition qItemDefinition : this.unnamedItemDefs) {
            if (!qItemDefinition.definesNode()) continue;
            defs.add(qItemDefinition);
        }
        for (List list : this.namedItemDefs.values()) {
            for (QItemDefinition qDef : list) {
                if (!qDef.definesNode()) continue;
                defs.add(qDef);
            }
        }
        if (defs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QNodeDefinition[defs.size()]);
    }

    @Override
    public QPropertyDefinition[] getAllQPropertyDefinitions() {
        if (this.namedItemDefs.size() == 0 && this.unnamedItemDefs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        ArrayList<QItemDefinition> defs = new ArrayList<QItemDefinition>(this.namedItemDefs.size() + this.unnamedItemDefs.size());
        for (QItemDefinition qItemDefinition : this.unnamedItemDefs) {
            if (qItemDefinition.definesNode()) continue;
            defs.add(qItemDefinition);
        }
        for (List list : this.namedItemDefs.values()) {
            for (QItemDefinition qDef : list) {
                if (qDef.definesNode()) continue;
                defs.add(qDef);
            }
        }
        if (defs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QPropertyDefinition[defs.size()]);
    }

    @Override
    public QNodeDefinition[] getAutoCreateQNodeDefinitions() {
        if (this.namedItemDefs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        ArrayList<QItemDefinition> defs = new ArrayList<QItemDefinition>(this.namedItemDefs.size());
        for (List<QItemDefinition> list : this.namedItemDefs.values()) {
            for (QItemDefinition qDef : list) {
                if (!qDef.definesNode() || !qDef.isAutoCreated()) continue;
                defs.add(qDef);
            }
        }
        if (defs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QNodeDefinition[defs.size()]);
    }

    @Override
    public QPropertyDefinition[] getAutoCreateQPropertyDefinitions() {
        if (this.namedItemDefs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        ArrayList<QItemDefinition> defs = new ArrayList<QItemDefinition>(this.namedItemDefs.size());
        for (List<QItemDefinition> list : this.namedItemDefs.values()) {
            for (QItemDefinition qDef : list) {
                if (qDef.definesNode() || !qDef.isAutoCreated()) continue;
                defs.add(qDef);
            }
        }
        if (defs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QPropertyDefinition[defs.size()]);
    }

    @Override
    public QPropertyDefinition[] getMandatoryQPropertyDefinitions() {
        if (this.namedItemDefs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        ArrayList<QItemDefinition> defs = new ArrayList<QItemDefinition>(this.namedItemDefs.size());
        for (List<QItemDefinition> list : this.namedItemDefs.values()) {
            for (QItemDefinition qDef : list) {
                if (qDef.definesNode() || !qDef.isMandatory()) continue;
                defs.add(qDef);
            }
        }
        if (defs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QPropertyDefinition[defs.size()]);
    }

    @Override
    public QNodeDefinition[] getMandatoryQNodeDefinitions() {
        if (this.namedItemDefs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        ArrayList<QItemDefinition> defs = new ArrayList<QItemDefinition>(this.namedItemDefs.size());
        for (List<QItemDefinition> list : this.namedItemDefs.values()) {
            for (QItemDefinition qDef : list) {
                if (!qDef.definesNode() || !qDef.isMandatory()) continue;
                defs.add(qDef);
            }
        }
        if (defs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QNodeDefinition[defs.size()]);
    }

    @Override
    public QNodeDefinition[] getNamedQNodeDefinitions(Name name) {
        List<QItemDefinition> list = this.namedItemDefs.get(name);
        if (list == null || list.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        ArrayList<QItemDefinition> defs = new ArrayList<QItemDefinition>(list.size());
        for (QItemDefinition qDef : list) {
            if (!qDef.definesNode()) continue;
            defs.add(qDef);
        }
        if (defs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QNodeDefinition[defs.size()]);
    }

    @Override
    public QNodeDefinition[] getUnnamedQNodeDefinitions() {
        if (this.unnamedItemDefs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        ArrayList<QItemDefinition> defs = new ArrayList<QItemDefinition>(this.unnamedItemDefs.size());
        for (QItemDefinition qDef : this.unnamedItemDefs) {
            if (!qDef.definesNode()) continue;
            defs.add(qDef);
        }
        if (defs.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QNodeDefinition[defs.size()]);
    }

    @Override
    public QPropertyDefinition[] getNamedQPropertyDefinitions(Name name) {
        List<QItemDefinition> list = this.namedItemDefs.get(name);
        if (list == null || list.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        ArrayList<QItemDefinition> defs = new ArrayList<QItemDefinition>(list.size());
        for (QItemDefinition qDef : list) {
            if (qDef.definesNode()) continue;
            defs.add(qDef);
        }
        if (defs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QPropertyDefinition[defs.size()]);
    }

    @Override
    public QPropertyDefinition[] getUnnamedQPropertyDefinitions() {
        if (this.unnamedItemDefs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        ArrayList<QItemDefinition> defs = new ArrayList<QItemDefinition>(this.unnamedItemDefs.size());
        for (QItemDefinition qDef : this.unnamedItemDefs) {
            if (qDef.definesNode()) continue;
            defs.add(qDef);
        }
        if (defs.size() == 0) {
            return QPropertyDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QPropertyDefinition[defs.size()]);
    }

    @Override
    public boolean includesNodeType(Name nodeTypeName) {
        return this.allNodeTypes.contains(nodeTypeName);
    }

    @Override
    public boolean includesNodeTypes(Name[] nodeTypeNames) {
        return this.allNodeTypes.containsAll(Arrays.asList(nodeTypeNames));
    }

    @Override
    public boolean supportsMixin(Name mixin) {
        if (this.supportedMixins == null) {
            return true;
        }
        return this.supportedMixins.contains(mixin);
    }

    @Override
    public void checkAddNodeConstraints(Name name, ItemDefinitionProvider definitionProvider) throws ConstraintViolationException {
        try {
            definitionProvider.getQNodeDefinition(this, name, null);
        }
        catch (NoSuchNodeTypeException e) {
            String msg = "internal eror: inconsistent node type";
            log.debug(msg);
            throw new ConstraintViolationException(msg, (Throwable)e);
        }
    }

    @Override
    public void checkAddNodeConstraints(Name name, QNodeTypeDefinition nodeTypeDefinition, ItemDefinitionProvider definitionProvider) throws ConstraintViolationException, NoSuchNodeTypeException {
        if (nodeTypeDefinition.isAbstract()) {
            throw new ConstraintViolationException("not allowed to add node " + name + ": " + nodeTypeDefinition.getName() + " is abstract and cannot be used as primary node type.");
        }
        if (nodeTypeDefinition.isMixin()) {
            throw new ConstraintViolationException("not allowed to add node " + name + ":" + nodeTypeDefinition.getName() + " is a mixin and cannot be used as primary node type.");
        }
        QNodeDefinition nd = definitionProvider.getQNodeDefinition(this, name, nodeTypeDefinition.getName());
        if (nd.isProtected()) {
            throw new ConstraintViolationException(name + " is protected.");
        }
        if (nd.isAutoCreated()) {
            throw new ConstraintViolationException(name + " is auto-created and can not be manually added");
        }
    }

    @Override
    public void checkRemoveItemConstraints(Name name) throws ConstraintViolationException {
        QItemDefinition[] defs = this.getNamedItemDefs(name);
        if (EffectiveNodeTypeImpl.hasRemoveConstaint(defs)) {
            throw new ConstraintViolationException("can't remove mandatory or protected item");
        }
    }

    @Override
    public boolean hasRemoveNodeConstraint(Name nodeName) {
        QNodeDefinition[] defs = this.getNamedQNodeDefinitions(nodeName);
        return EffectiveNodeTypeImpl.hasRemoveConstaint((QItemDefinition[])defs);
    }

    @Override
    public boolean hasRemovePropertyConstraint(Name propertyName) {
        QPropertyDefinition[] defs = this.getNamedQPropertyDefinitions(propertyName);
        return EffectiveNodeTypeImpl.hasRemoveConstaint((QItemDefinition[])defs);
    }

    private static boolean hasRemoveConstaint(QItemDefinition[] defs) {
        if (defs != null) {
            for (int i = 0; i < defs.length; ++i) {
                if (defs[i].isMandatory()) {
                    return true;
                }
                if (!defs[i].isProtected()) continue;
                return true;
            }
        }
        return false;
    }

    private QItemDefinition[] getNamedItemDefs() {
        if (this.namedItemDefs.size() == 0) {
            return QItemDefinition.EMPTY_ARRAY;
        }
        ArrayList<QItemDefinition> defs = new ArrayList<QItemDefinition>(this.namedItemDefs.size());
        for (List<QItemDefinition> list : this.namedItemDefs.values()) {
            defs.addAll(list);
        }
        if (defs.size() == 0) {
            return QItemDefinition.EMPTY_ARRAY;
        }
        return defs.toArray(new QItemDefinition[defs.size()]);
    }

    private QItemDefinition[] getNamedItemDefs(Name name) {
        List<QItemDefinition> list = this.namedItemDefs.get(name);
        if (list == null || list.size() == 0) {
            return QNodeDefinition.EMPTY_ARRAY;
        }
        return list.toArray(new QItemDefinition[list.size()]);
    }

    private QItemDefinition[] getUnnamedItemDefs() {
        if (this.unnamedItemDefs.size() == 0) {
            return QItemDefinition.EMPTY_ARRAY;
        }
        return this.unnamedItemDefs.toArray(new QItemDefinition[this.unnamedItemDefs.size()]);
    }

    EffectiveNodeTypeImpl merge(EffectiveNodeTypeImpl other) throws ConstraintViolationException {
        EffectiveNodeTypeImpl copy = (EffectiveNodeTypeImpl)this.clone();
        copy.internalMerge(other, false);
        return copy;
    }

    synchronized void internalMerge(EffectiveNodeTypeImpl other, boolean supertype) throws ConstraintViolationException {
        String msg;
        QItemDefinition qDef;
        int i;
        Name[] nta = other.getAllNodeTypes();
        int includedCount = 0;
        for (int i2 = 0; i2 < nta.length; ++i2) {
            if (!this.includesNodeType(nta[i2])) continue;
            log.debug("node type '" + nta[i2] + "' is already contained.");
            ++includedCount;
        }
        if (includedCount == nta.length) {
            return;
        }
        QItemDefinition[] defs = other.getNamedItemDefs();
        for (i = 0; i < defs.length; ++i) {
            qDef = defs[i];
            if (this.includesNodeType(qDef.getDeclaringNodeType())) continue;
            Name name = qDef.getName();
            List<QItemDefinition> existingDefs = this.namedItemDefs.get(name);
            if (existingDefs != null) {
                if (existingDefs.size() > 0) {
                    for (int j = 0; j < existingDefs.size(); ++j) {
                        QItemDefinition qItemDef = existingDefs.get(j);
                        if (qDef.isAutoCreated() || qItemDef.isAutoCreated()) {
                            msg = "The item definition for '" + name + "' in node type '" + qDef.getDeclaringNodeType() + "' conflicts with the one of node type '" + qItemDef.getDeclaringNodeType() + "': name collision with auto-create definition";
                            log.debug(msg);
                            throw new ConstraintViolationException(msg);
                        }
                        if (qDef.definesNode() != qItemDef.definesNode()) continue;
                        if (!qDef.definesNode()) {
                            QPropertyDefinition pd = (QPropertyDefinition)qDef;
                            QPropertyDefinition epd = (QPropertyDefinition)qItemDef;
                            if (pd.getRequiredType() != epd.getRequiredType() || pd.isMultiple() != epd.isMultiple()) continue;
                            String msg2 = "The property definition for '" + name + "' in node type '" + qDef.getDeclaringNodeType() + "' conflicts with the one of node type '" + qItemDef.getDeclaringNodeType() + "': ambiguous property definition. " + "they must differ in required type " + "or cardinality.";
                            log.debug(msg2);
                            throw new ConstraintViolationException(msg2);
                        }
                        msg = "The child node definition for '" + name + "' in node type '" + qDef.getDeclaringNodeType() + "' conflicts with the one of node type '" + qItemDef.getDeclaringNodeType() + "': ambiguous child node definition. name must differ.";
                        log.debug(msg);
                        throw new ConstraintViolationException(msg);
                    }
                }
            } else {
                existingDefs = new ArrayList<QItemDefinition>();
                this.namedItemDefs.put(name, existingDefs);
            }
            existingDefs.add(qDef);
        }
        defs = other.getUnnamedItemDefs();
        for (i = 0; i < defs.length; ++i) {
            qDef = defs[i];
            if (this.includesNodeType(qDef.getDeclaringNodeType())) continue;
            for (QItemDefinition existing : this.unnamedItemDefs) {
                if (qDef.definesNode() != existing.definesNode()) continue;
                if (!qDef.definesNode()) {
                    QPropertyDefinition pd = (QPropertyDefinition)qDef;
                    QPropertyDefinition epd = (QPropertyDefinition)existing;
                    if (pd.getRequiredType() != epd.getRequiredType() || pd.isMultiple() != epd.isMultiple() || pd.getOnParentVersion() != epd.getOnParentVersion()) continue;
                    msg = "A property definition in node type '" + qDef.getDeclaringNodeType() + "' conflicts with node type '" + existing.getDeclaringNodeType() + "': ambiguous residual property definition";
                    log.debug(msg);
                    throw new ConstraintViolationException(msg);
                }
                QNodeDefinition nd = (QNodeDefinition)qDef;
                QNodeDefinition end = (QNodeDefinition)existing;
                if (!Arrays.equals(nd.getRequiredPrimaryTypes(), end.getRequiredPrimaryTypes()) || !(nd.getDefaultPrimaryType() == null ? end.getDefaultPrimaryType() == null : nd.getDefaultPrimaryType().equals(end.getDefaultPrimaryType()))) continue;
                msg = "A child node definition in node type '" + qDef.getDeclaringNodeType() + "' conflicts with node type '" + existing.getDeclaringNodeType() + "': ambiguous residual child node definition";
                log.debug(msg);
                throw new ConstraintViolationException(msg);
            }
            this.unnamedItemDefs.add(qDef);
        }
        for (i = 0; i < nta.length; ++i) {
            this.allNodeTypes.add(nta[i]);
        }
        if (supertype) {
            nta = other.getMergedNodeTypes();
            for (i = 0; i < nta.length; ++i) {
                this.inheritedNodeTypes.add(nta[i]);
            }
            nta = other.getInheritedNodeTypes();
            for (i = 0; i < nta.length; ++i) {
                this.inheritedNodeTypes.add(nta[i]);
            }
        } else {
            nta = other.getMergedNodeTypes();
            for (i = 0; i < nta.length; ++i) {
                this.mergedNodeTypes.add(nta[i]);
            }
            nta = other.getInheritedNodeTypes();
            for (i = 0; i < nta.length; ++i) {
                this.inheritedNodeTypes.add(nta[i]);
            }
        }
    }

    protected Object clone() {
        EffectiveNodeTypeImpl clone = new EffectiveNodeTypeImpl(this.mergedNodeTypes, this.inheritedNodeTypes, this.allNodeTypes, this.namedItemDefs, this.unnamedItemDefs, this.supportedMixins);
        return clone;
    }
}

