/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.hierarchy;

import java.util.Iterator;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EntryValidation {
    private static Logger log = LoggerFactory.getLogger(EntryValidation.class);

    EntryValidation() {
    }

    static boolean containsValidNodeEntry(Iterator<NodeEntry> nodeEntries) {
        boolean hasValid = false;
        while (nodeEntries.hasNext() && !hasValid) {
            NodeEntry cne = nodeEntries.next();
            hasValid = EntryValidation.isValidNodeEntry(cne);
        }
        return hasValid;
    }

    static boolean isValidNodeEntry(NodeEntry cne) {
        if (cne == null) {
            return false;
        }
        boolean isValid = false;
        if (cne.isAvailable()) {
            try {
                isValid = cne.getNodeState().isValid();
            }
            catch (ItemNotFoundException e) {
            }
            catch (RepositoryException repositoryException) {}
        } else {
            isValid = true;
        }
        return isValid;
    }

    static boolean isValidWorkspaceNodeEntry(NodeEntry cne) {
        if (cne == null) {
            return false;
        }
        int status = cne.getStatus();
        return status != 4 && status != 8;
    }

    static boolean isValidPropertyEntry(PropertyEntry cpe) {
        if (cpe == null) {
            return false;
        }
        boolean isValid = false;
        if (cpe.isAvailable()) {
            try {
                isValid = cpe.getPropertyState().isValid();
            }
            catch (ItemNotFoundException e) {
            }
            catch (RepositoryException repositoryException) {}
        } else {
            isValid = true;
        }
        return isValid;
    }
}

