/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import javax.jcr.SimpleCredentials;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;

class CredentialsWrapper {
    private final String userId;
    private final UsernamePasswordCredentials credentials;

    CredentialsWrapper(javax.jcr.Credentials creds) {
        if (creds == null) {
            this.userId = "";
            this.credentials = null;
        } else if (creds instanceof SimpleCredentials) {
            SimpleCredentials sCred = (SimpleCredentials)creds;
            this.userId = sCred.getUserID();
            this.credentials = new UsernamePasswordCredentials(this.userId, String.valueOf(sCred.getPassword()));
        } else {
            this.userId = "";
            this.credentials = new UsernamePasswordCredentials(creds.toString());
        }
    }

    String getUserId() {
        return this.userId;
    }

    Credentials getCredentials() {
        return this.credentials;
    }
}

