/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.observation;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.jcr.observation.EventFactory;
import org.apache.jackrabbit.oak.jcr.observation.QueueingHandler;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.observation.EventGenerator;
import org.apache.jackrabbit.oak.plugins.observation.EventHandler;
import org.apache.jackrabbit.oak.plugins.observation.FilteredHandler;
import org.apache.jackrabbit.oak.plugins.observation.filter.EventFilter;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class EventQueue
implements EventIterator {
    private final EventGenerator generator;
    private final LinkedList<Event> queue = Lists.newLinkedList();
    private long position = 0L;

    public EventQueue(@Nonnull NamePathMapper mapper, CommitInfo info, @Nonnull NodeState before, @Nonnull NodeState after, @Nonnull Iterable<String> basePaths, @Nonnull EventFilter filter) {
        this.generator = new EventGenerator();
        EventFactory factory = new EventFactory(mapper, info);
        FilteredHandler handler = new FilteredHandler(filter, (EventHandler)new QueueingHandler(this, factory, before, after));
        for (String path : basePaths) {
            EventQueue.addHandler(before, after, path, (EventHandler)handler, this.generator);
        }
    }

    private static void addHandler(NodeState before, NodeState after, String path, EventHandler handler, EventGenerator generator) {
        for (String name : PathUtils.elements((String)path)) {
            if ((handler = handler.getChildHandler(name, before = before.getChildNode(name), after = after.getChildNode(name))) != null) continue;
            return;
        }
        generator.addHandler(before, after, handler);
    }

    void addEvent(Event event) {
        this.queue.add(event);
    }

    public long getSize() {
        if (this.generator.isDone()) {
            return this.position + (long)this.queue.size();
        }
        return -1L;
    }

    public long getPosition() {
        return this.position;
    }

    public boolean hasNext() {
        while (this.queue.isEmpty()) {
            if (this.generator.isDone()) {
                return false;
            }
            this.generator.generate();
        }
        return true;
    }

    public void skip(long skipNum) {
        while (skipNum > (long)this.queue.size()) {
            this.position += (long)this.queue.size();
            skipNum -= (long)this.queue.size();
            this.queue.clear();
            if (!this.generator.isDone()) {
                this.generator.generate();
                continue;
            }
            throw new NoSuchElementException("Not enough events to skip");
        }
        this.queue.subList(0, (int)skipNum).clear();
        this.position += skipNum;
    }

    public Event nextEvent() {
        if (this.hasNext()) {
            ++this.position;
            return this.queue.removeFirst();
        }
        throw new NoSuchElementException();
    }

    public Event next() {
        return this.nextEvent();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

