/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.version;

import com.google.common.base.Preconditions;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.LabelExistsVersionException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.version.VersionStorage;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.version.ReadOnlyVersionManager;
import org.apache.jackrabbit.oak.util.TreeUtil;
import org.apache.jackrabbit.util.ISO8601;

public class ReadWriteVersionManager
extends ReadOnlyVersionManager {
    private final SessionDelegate sessionDelegate;
    private final VersionStorage versionStorage;

    public ReadWriteVersionManager(@Nonnull SessionDelegate sessionDelegate) {
        this.sessionDelegate = sessionDelegate;
        this.versionStorage = new VersionStorage(sessionDelegate.getRoot());
    }

    protected void refresh() throws RepositoryException {
        this.sessionDelegate.refresh(true);
    }

    @Nonnull
    protected Tree getVersionStorage() {
        return this.versionStorage.getTree();
    }

    @Nonnull
    protected Root getWorkspaceRoot() {
        return this.sessionDelegate.getRoot();
    }

    @Nonnull
    protected ReadOnlyNodeTypeManager getNodeTypeManager() {
        return ReadOnlyNodeTypeManager.getInstance((Root)this.sessionDelegate.getRoot(), (NamePathMapper)NamePathMapper.DEFAULT);
    }

    @Nonnull
    public Tree checkin(@Nonnull Tree versionable) throws RepositoryException, InvalidItemStateException, UnsupportedRepositoryOperationException {
        if (this.sessionDelegate.hasPendingChanges()) {
            throw new InvalidItemStateException("Unable to perform checkin. Session has pending changes.");
        }
        if (!this.isVersionable(versionable)) {
            throw new UnsupportedRepositoryOperationException(versionable.getPath() + " is not versionable");
        }
        if (this.isCheckedOut(versionable)) {
            versionable.setProperty("jcr:isCheckedOut", (Object)Boolean.FALSE, Type.BOOLEAN);
            Tree baseVersion = this.getBaseVersion(versionable);
            PropertyState created = baseVersion.getProperty("jcr:created");
            if (created != null) {
                long c = ISO8601.parse((String)((String)created.getValue(Type.DATE))).getTimeInMillis();
                while (System.currentTimeMillis() == c) {
                }
            }
            try {
                this.sessionDelegate.commit();
                this.refresh();
            }
            catch (CommitFailedException e) {
                this.sessionDelegate.refresh(true);
                throw e.asRepositoryException();
            }
        }
        return this.getBaseVersion(this.getWorkspaceRoot().getTree(versionable.getPath()));
    }

    public void checkout(@Nonnull Root workspaceRoot, @Nonnull String versionablePath) throws UnsupportedRepositoryOperationException, InvalidItemStateException, RepositoryException {
        Preconditions.checkState((!workspaceRoot.hasPendingChanges() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)PathUtils.isAbsolute((String)versionablePath));
        Tree versionable = workspaceRoot.getTree(versionablePath);
        if (!this.isVersionable(versionable)) {
            throw new UnsupportedRepositoryOperationException(versionable.getPath() + " is not versionable");
        }
        if (!this.isCheckedOut(versionable)) {
            versionable.setProperty("jcr:isCheckedOut", (Object)Boolean.TRUE, Type.BOOLEAN);
            try {
                workspaceRoot.commit();
                this.refresh();
            }
            catch (CommitFailedException e) {
                workspaceRoot.refresh();
                throw e.asRepositoryException();
            }
        }
    }

    public void addVersionLabel(@Nonnull VersionStorage versionStorage, @Nonnull String versionHistoryOakRelPath, @Nonnull String versionOakName, @Nonnull String oakVersionLabel, boolean moveLabel) throws RepositoryException {
        String labelPath;
        Tree versionHistory = TreeUtil.getTree((Tree)((Tree)Preconditions.checkNotNull((Object)versionStorage.getTree())), (String)((String)Preconditions.checkNotNull((Object)versionHistoryOakRelPath)));
        Tree labels = ((Tree)Preconditions.checkNotNull((Object)versionHistory)).getChild("jcr:versionLabels");
        if (labels.hasProperty((String)Preconditions.checkNotNull((Object)oakVersionLabel))) {
            if (moveLabel) {
                labelPath = PathUtils.concat((String)versionHistoryOakRelPath, (String[])new String[]{"jcr:versionLabels", oakVersionLabel, "dummy"});
                versionStorage.getTree().setProperty("rep:removeVersionLabels", Collections.singleton(labelPath), Type.PATHS);
            } else {
                throw new LabelExistsVersionException("Version label '" + oakVersionLabel + "' already exists on this version history");
            }
        }
        labelPath = PathUtils.concat((String)versionHistoryOakRelPath, (String[])new String[]{"jcr:versionLabels", oakVersionLabel, (String)Preconditions.checkNotNull((Object)versionOakName)});
        versionStorage.getTree().setProperty("rep:addVersionLabels", Collections.singleton(labelPath), Type.PATHS);
        try {
            this.sessionDelegate.commit(versionStorage.getRoot());
            this.refresh();
        }
        catch (CommitFailedException e) {
            versionStorage.refresh();
            throw e.asRepositoryException();
        }
    }

    public void removeVersionLabel(@Nonnull VersionStorage versionStorage, @Nonnull String versionHistoryOakRelPath, @Nonnull String oakVersionLabel) throws RepositoryException {
        Tree versionHistory = TreeUtil.getTree((Tree)((Tree)Preconditions.checkNotNull((Object)versionStorage.getTree())), (String)((String)Preconditions.checkNotNull((Object)versionHistoryOakRelPath)));
        Tree labels = ((Tree)Preconditions.checkNotNull((Object)versionHistory)).getChild("jcr:versionLabels");
        if (!labels.hasProperty(oakVersionLabel)) {
            throw new VersionException("Version label " + oakVersionLabel + " does not exist on this version history");
        }
        String labelPath = PathUtils.concat((String)versionHistoryOakRelPath, (String[])new String[]{"jcr:versionLabels", oakVersionLabel, "dummy"});
        versionStorage.getTree().setProperty("rep:removeVersionLabels", Collections.singleton(labelPath), Type.PATHS);
        try {
            this.sessionDelegate.commit(versionStorage.getRoot());
            this.refresh();
        }
        catch (CommitFailedException e) {
            versionStorage.refresh();
            throw e.asRepositoryException();
        }
    }

    public void removeVersion(@Nonnull VersionStorage versionStorage, @Nonnull String versionHistoryOakRelPath, @Nonnull String oakVersionName) throws RepositoryException {
        Tree versionHistory = TreeUtil.getTree((Tree)versionStorage.getTree(), (String)versionHistoryOakRelPath);
        if (!versionHistory.exists()) {
            throw new VersionException("Version history " + versionHistoryOakRelPath + " does not exist on this version storage");
        }
        Tree version = versionHistory.getChild(oakVersionName);
        if (!version.exists()) {
            throw new VersionException("Version " + oakVersionName + " does not exist on this version history");
        }
        String versionPath = PathUtils.concat((String)versionHistoryOakRelPath, (String)oakVersionName);
        versionStorage.getTree().setProperty("rep:removeVersion", Collections.singleton(versionPath), Type.PATHS);
        try {
            this.sessionDelegate.commit(versionStorage.getRoot());
            this.refresh();
        }
        catch (CommitFailedException e) {
            versionStorage.refresh();
            throw e.asRepositoryException();
        }
    }
}

