/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import com.google.inject.Module;
import java.io.IOException;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.atmos.AtmosApiMetadata;
import org.jclouds.atmos.AtmosAsyncClient;
import org.jclouds.atmos.blobstore.functions.BlobToObject;
import org.jclouds.atmos.config.AtmosRestClientModule;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.atmos.filters.SignRequest;
import org.jclouds.atmos.functions.ParseDirectoryListFromContentAndHeaders;
import org.jclouds.atmos.functions.ParseNullableURIFromListOrLocationHeaderIf20x;
import org.jclouds.atmos.functions.ParseObjectFromHeadersAndHttpContent;
import org.jclouds.atmos.functions.ParseSystemMetadataFromHeaders;
import org.jclouds.atmos.functions.ReturnTrueIfGroupACLIsOtherRead;
import org.jclouds.atmos.options.ListOptions;
import org.jclouds.atmos.options.PutOptions;
import org.jclouds.blobstore.BlobStoreFallbacks;
import org.jclouds.blobstore.binders.BindBlobToMultipartFormTest;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.functions.ParseURIFromListOrLocationHeaderIf20x;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.http.options.GetOptions;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.internal.BaseAsyncClientTest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AtmosAsyncClientTest")
public class AtmosAsyncClientTest
extends BaseAsyncClientTest<AtmosAsyncClient> {
    private BlobToObject blobToObject;
    protected String provider = "atmos";

    public void testListDirectories() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AtmosAsyncClient.class, (String)"listDirectories", (Class[])new Class[]{ListOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)request, "GET https://accesspoint.atmosonline.com/rest/namespace/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: text/xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseDirectoryListFromContentAndHeaders.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testListDirectory() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AtmosAsyncClient.class, (String)"listDirectory", (Class[])new Class[]{String.class, ListOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"directory"));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://accesspoint.atmosonline.com/rest/namespace/directory/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: text/xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseDirectoryListFromContentAndHeaders.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, BlobStoreFallbacks.ThrowContainerNotFoundOn404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListDirectoriesOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AtmosAsyncClient.class, (String)"listDirectories", (Class[])new Class[]{ListOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)new ListOptions().limit(1).token("asda")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://accesspoint.atmosonline.com/rest/namespace/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: text/xml\nx-emc-limit: 1\nx-emc-token: asda\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseDirectoryListFromContentAndHeaders.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testListDirectoryOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AtmosAsyncClient.class, (String)"listDirectory", (Class[])new Class[]{String.class, ListOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"directory", (Object)new ListOptions().limit(1).token("asda")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://accesspoint.atmosonline.com/rest/namespace/directory/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: text/xml\nx-emc-limit: 1\nx-emc-token: asda\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseDirectoryListFromContentAndHeaders.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, BlobStoreFallbacks.ThrowContainerNotFoundOn404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testCreateDirectory() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AtmosAsyncClient.class, (String)"createDirectory", (Class[])new Class[]{String.class, PutOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"dir"));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://accesspoint.atmosonline.com/rest/namespace/dir/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: */*\n");
        this.assertPayloadEquals((HttpRequest)request, "", "application/octet-stream", false);
        this.assertResponseParserClassEquals(method, request, ParseURIFromListOrLocationHeaderIf20x.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, BlobStoreFallbacks.NullOnKeyAlreadyExists.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testCreateDirectoryOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AtmosAsyncClient.class, (String)"createDirectory", (Class[])new Class[]{String.class, PutOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"dir", (Object)PutOptions.Builder.publicRead()));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://accesspoint.atmosonline.com/rest/namespace/dir/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: */*\nx-emc-groupacl: other=READ\nx-emc-useracl: root=FULL_CONTROL\n");
        this.assertPayloadEquals((HttpRequest)request, "", "application/octet-stream", false);
        this.assertResponseParserClassEquals(method, request, ParseURIFromListOrLocationHeaderIf20x.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, BlobStoreFallbacks.NullOnKeyAlreadyExists.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testCreateFile() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AtmosAsyncClient.class, (String)"createFile", (Class[])new Class[]{String.class, AtmosObject.class, PutOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"dir", (Object)this.blobToObject.apply(BindBlobToMultipartFormTest.TEST_BLOB)));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://accesspoint.atmosonline.com/rest/namespace/dir/hello HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: */*\nExpect: 100-continue\n");
        this.assertPayloadEquals((HttpRequest)request, "hello", "text/plain", false);
        this.assertResponseParserClassEquals(method, request, ParseNullableURIFromListOrLocationHeaderIf20x.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testCreateFileOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AtmosAsyncClient.class, (String)"createFile", (Class[])new Class[]{String.class, AtmosObject.class, PutOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"dir", (Object)this.blobToObject.apply(BindBlobToMultipartFormTest.TEST_BLOB), (Object)PutOptions.Builder.publicRead()));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://accesspoint.atmosonline.com/rest/namespace/dir/hello HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: */*\nExpect: 100-continue\nx-emc-groupacl: other=READ\nx-emc-useracl: root=FULL_CONTROL\n");
        this.assertPayloadEquals((HttpRequest)request, "hello", "text/plain", false);
        this.assertResponseParserClassEquals(method, request, ParseNullableURIFromListOrLocationHeaderIf20x.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testUpdateFile() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AtmosAsyncClient.class, (String)"updateFile", (Class[])new Class[]{String.class, AtmosObject.class, PutOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"dir", (Object)this.blobToObject.apply(BindBlobToMultipartFormTest.TEST_BLOB)));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://accesspoint.atmosonline.com/rest/namespace/dir/hello HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: */*\nExpect: 100-continue\n");
        this.assertPayloadEquals((HttpRequest)request, "hello", "text/plain", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, BlobStoreFallbacks.ThrowKeyNotFoundOn404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testUpdateFileOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AtmosAsyncClient.class, (String)"updateFile", (Class[])new Class[]{String.class, AtmosObject.class, PutOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"dir", (Object)this.blobToObject.apply(BindBlobToMultipartFormTest.TEST_BLOB), (Object)PutOptions.Builder.publicRead()));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://accesspoint.atmosonline.com/rest/namespace/dir/hello HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: */*\nExpect: 100-continue\nx-emc-groupacl: other=READ\nx-emc-useracl: root=FULL_CONTROL\n");
        this.assertPayloadEquals((HttpRequest)request, "hello", "text/plain", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, BlobStoreFallbacks.ThrowKeyNotFoundOn404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testReadFile() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AtmosAsyncClient.class, (String)"readFile", (Class[])new Class[]{String.class, GetOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"dir/file"));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://accesspoint.atmosonline.com/rest/namespace/dir/file HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: */*\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseObjectFromHeadersAndHttpContent.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetSystemMetadata() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AtmosAsyncClient.class, (String)"getSystemMetadata", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"dir/file"));
        this.assertRequestLineEquals((HttpRequest)request, "HEAD https://accesspoint.atmosonline.com/rest/namespace/dir/file HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: */*\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSystemMetadataFromHeaders.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeletePath() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AtmosAsyncClient.class, (String)"deletePath", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"dir/file"));
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://accesspoint.atmosonline.com/rest/namespace/dir/file HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: */*\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testIsPublic() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AtmosAsyncClient.class, (String)"isPublic", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"dir/file"));
        this.assertRequestLineEquals((HttpRequest)request, "HEAD https://accesspoint.atmosonline.com/rest/namespace/dir/file HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: */*\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReturnTrueIfGroupACLIsOtherRead.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.FalseOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testNewObject() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AtmosAsyncClient.class, (String)"newObject", (Class[])new Class[0]);
        Assert.assertEquals((Object)method.getReturnType().getRawType(), AtmosObject.class);
    }

    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), SignRequest.class);
    }

    @BeforeClass
    protected void setupFactory() throws IOException {
        super.setupFactory();
        this.blobToObject = (BlobToObject)this.injector.getInstance(BlobToObject.class);
    }

    protected Module createModule() {
        return new TestAtmosRestClientModule();
    }

    public ApiMetadata createApiMetadata() {
        return new AtmosApiMetadata();
    }

    @ConfiguresRestClient
    private static final class TestAtmosRestClientModule
    extends AtmosRestClientModule {
        private TestAtmosRestClientModule() {
        }

        protected void configure() {
            super.configure();
        }

        protected String provideTimeStamp(@TimeStamp Supplier<String> cache) {
            return "Thu, 05 Jun 2008 16:38:19 GMT";
        }
    }
}

