/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore.config;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Injector;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.atmos.AtmosApiMetadata;
import org.jclouds.atmos.blobstore.strategy.FindMD5InUserMetadata;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.internal.BlobStoreContextImpl;
import org.jclouds.blobstore.strategy.ContainsValueInListStrategy;
import org.jclouds.logging.config.NullLoggingModule;
import org.jclouds.rest.internal.BaseRestApiTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class AtmosBlobStoreModuleTest {
    Injector createInjector() {
        return ContextBuilder.newBuilder((ApiMetadata)new AtmosApiMetadata()).credentials("uid", "key").modules((Iterable)ImmutableSet.of((Object)new BaseRestApiTest.MockModule(), (Object)new NullLoggingModule())).buildInjector();
    }

    @Test
    void testContextImpl() {
        Injector injector = this.createInjector();
        BlobStoreContext handler = (BlobStoreContext)injector.getInstance(BlobStoreContext.class);
        Assert.assertEquals(handler.getClass(), BlobStoreContextImpl.class);
        ContainsValueInListStrategy valueList = (ContainsValueInListStrategy)injector.getInstance(ContainsValueInListStrategy.class);
        Assert.assertEquals(valueList.getClass(), FindMD5InUserMetadata.class);
    }
}

