/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import javax.inject.Singleton;
import org.jclouds.atmos.domain.BoundedSet;
import org.jclouds.atmos.domain.DirectoryEntry;
import org.jclouds.atmos.domain.FileType;
import org.jclouds.atmos.domain.internal.BoundedLinkedHashSet;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;

@Singleton
public class ResourceMetadataListToDirectoryEntryList
implements Function<PageSet<? extends StorageMetadata>, BoundedSet<? extends DirectoryEntry>> {
    public BoundedSet<DirectoryEntry> apply(PageSet<? extends StorageMetadata> from) {
        return new BoundedLinkedHashSet(Iterables.transform(from, (Function)new Function<StorageMetadata, DirectoryEntry>(){

            public DirectoryEntry apply(StorageMetadata from) {
                FileType type = from.getType() == StorageType.FOLDER || from.getType() == StorageType.RELATIVE_PATH ? FileType.DIRECTORY : FileType.REGULAR;
                return new DirectoryEntry(from.getProviderId(), type, from.getName());
            }
        }), from.getNextMarker());
    }
}

