/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore.integration;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.integration.internal.BaseBlobIntegrationTest;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"integration", "live"})
public class AtmosIntegrationLiveTest
extends BaseBlobIntegrationTest {
    public AtmosIntegrationLiveTest() {
        this.provider = "atmos";
    }

    @DataProvider(name="delete")
    public Object[][] createData() {
        return new Object[][]{{"normal"}};
    }

    @Test(enabled=false)
    public void testGetIfMatch() {
    }

    @Test(enabled=false)
    public void testGetIfModifiedSince() {
    }

    @Test(enabled=false)
    public void testGetIfNoneMatch() {
    }

    @Test(enabled=false)
    public void testGetIfUnmodifiedSince() {
    }

    @Test(enabled=false)
    public void testGetRange() {
    }

    @Test(enabled=false)
    public void testGetTwoRanges() {
    }

    protected void checkContentDisposition(Blob blob, String contentDisposition) {
        assert (blob.getPayload().getContentMetadata().getContentDisposition() == null);
        assert (blob.getMetadata().getContentMetadata().getContentDisposition() == null);
    }

    protected void checkContentEncoding(Blob blob, String contentEncoding) {
        assert (blob.getPayload().getContentMetadata().getContentEncoding() == null);
        assert (blob.getMetadata().getContentMetadata().getContentEncoding() == null);
    }

    protected void checkContentLanguage(Blob blob, String contentLanguage) {
        assert (blob.getPayload().getContentMetadata().getContentLanguage() == null);
        assert (blob.getMetadata().getContentMetadata().getContentLanguage() == null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testPutObjectStream() throws InterruptedException, IOException, ExecutionException {
        super.testPutObjectStream();
    }

    protected void checkMD5(BlobMetadata metadata) throws IOException {
        Assert.assertEquals((byte[])metadata.getContentMetadata().getContentMD5(), null);
    }

    public void testCreateBlobWithExpiry() throws InterruptedException {
        throw new SkipException("Expiration not yet implemented");
    }

    @Test(enabled=false)
    public void testMetadata() {
    }

    @Test(enabled=false)
    public void testPutObject() throws Exception {
    }
}

