/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.fallbacks;

import com.google.common.util.concurrent.Futures;
import java.net.URI;
import java.util.concurrent.Future;
import org.jclouds.atmos.fallbacks.EndpointIfAlreadyExists;
import org.jclouds.blobstore.KeyAlreadyExistsException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class EndpointIfAlreadyExistsTest {
    @Test
    public void testFoundIsNullWhenEndpointNotSet() throws Exception {
        Assert.assertNull((Object)Futures.getUnchecked((Future)new EndpointIfAlreadyExists().create((Throwable)new KeyAlreadyExistsException())));
    }

    @Test
    public void testFoundIsEndpointWhenSet() throws Exception {
        Assert.assertEquals((Object)Futures.getUnchecked((Future)new EndpointIfAlreadyExists().setEndpoint(URI.create("foo")).create((Throwable)new KeyAlreadyExistsException())), (Object)URI.create("foo"));
    }

    @Test(expectedExceptions={RuntimeException.class})
    public void testNotFoundPropagates() throws Exception {
        new EndpointIfAlreadyExists().create((Throwable)new RuntimeException());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullIsBad() throws Exception {
        new EndpointIfAlreadyExists().create(null);
    }
}

