/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.filters;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.jclouds.ContextBuilder;
import org.jclouds.atmos.config.AtmosRestClientModule;
import org.jclouds.atmos.filters.SignRequest;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpRequest;
import org.jclouds.logging.config.NullLoggingModule;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.internal.BaseRestApiTest;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class SignRequestTest {
    private static final String EXPECTED_SIGNATURE = "WHJo1MFevMnK4jCthJ974L3YHoo=";
    private static final String UID = "6039ac182f194e15b9261d73ce044939/user1";
    private static final String DEFAULT_DATE = "Thu, 05 Jun 2008 16:38:19 GMT";
    private static final String KEY = "LJLuryj6zs8ste6Y3jTGQp71xq0=";
    private SignRequest filter;

    @Test
    void testCreateStringToSign() throws IOException {
        String expects = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/hashstring.txt"));
        HttpRequest request = this.newRequest((Multimap<String, String>)this.preconstructedHeaders().build());
        String toSign = this.filter.createStringToSign(request);
        Assert.assertEquals((String)toSign, (String)expects);
    }

    @Test
    void testSignString() throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        HttpRequest request = this.newRequest((Multimap<String, String>)this.preconstructedHeaders().build());
        String toSign = this.filter.createStringToSign(request);
        String signature = this.filter.signString(toSign);
        Assert.assertEquals((String)signature, (String)EXPECTED_SIGNATURE);
    }

    @Test
    void testFilter() throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        HttpRequest request = this.newRequest((Multimap<String, String>)this.inputHeaders().build());
        request = this.filter.filter(request);
        Assert.assertEquals((String)request.getFirstHeaderOrNull("x-emc-signature"), (String)EXPECTED_SIGNATURE);
    }

    @Test
    void testFilterReplacesOldValues() throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        HttpRequest request = this.newRequest((Multimap<String, String>)this.inputHeaders().put((Object)"x-emc-signature", (Object)"foo").put((Object)"Date", (Object)"foo").put((Object)"x-emc-date", (Object)"foo").put((Object)"x-emc-uid", (Object)"foo").build());
        request = this.filter.filter(request);
        Assert.assertEquals((String)request.getFirstHeaderOrNull("x-emc-signature"), (String)EXPECTED_SIGNATURE);
    }

    @BeforeClass
    protected void createFilter() {
        Injector injector = ContextBuilder.newBuilder((String)"atmos").credentials(UID, KEY).modules((Iterable)ImmutableSet.of((Object)new BaseRestApiTest.MockModule(), (Object)((Object)new TestAtmosRestClientModule()), (Object)new NullLoggingModule())).buildInjector();
        this.filter = (SignRequest)injector.getInstance(SignRequest.class);
    }

    public HttpRequest newRequest(Multimap<String, String> headers) {
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("http://localhost/rest/objects").headers(headers)).build();
        request.setPayload("");
        request.getPayload().getContentMetadata().setContentLength(Long.valueOf(4286L));
        request.getPayload().getContentMetadata().setContentType("application/octet-stream");
        return request;
    }

    protected ImmutableMultimap.Builder<String, String> preconstructedHeaders() {
        ImmutableMultimap.Builder<String, String> builder = this.inputHeaders();
        builder.put((Object)"Date", (Object)DEFAULT_DATE);
        builder.put((Object)"x-emc-uid", (Object)UID);
        return builder;
    }

    protected ImmutableMultimap.Builder<String, String> inputHeaders() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)"x-emc-listable-meta", (Object)"part4/part7/part8=quick");
        builder.put((Object)"x-emc-meta", (Object)"part1=buy");
        builder.put((Object)"Accept", (Object)"*/*");
        builder.put((Object)"x-emc-useracl", (Object)"john=FULL_CONTROL,mary=WRITE");
        builder.put((Object)"x-emc-groupacl", (Object)"other=NONE");
        builder.put((Object)"x-emc-date", (Object)DEFAULT_DATE);
        builder.put((Object)"Host", (Object)"10.5.115.118");
        return builder;
    }

    @ConfiguresRestClient
    private static final class TestAtmosRestClientModule
    extends AtmosRestClientModule {
        private TestAtmosRestClientModule() {
        }

        protected void configure() {
            super.configure();
        }

        protected String provideTimeStamp(@TimeStamp Supplier<String> cache) {
            return SignRequestTest.DEFAULT_DATE;
        }
    }
}

