/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.jclouds.atmos.domain.BoundedSet;
import org.jclouds.atmos.domain.DirectoryEntry;
import org.jclouds.atmos.domain.FileType;
import org.jclouds.atmos.domain.internal.BoundedLinkedHashSet;
import org.jclouds.atmos.functions.ParseDirectoryListFromContentAndHeaders;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.io.Payloads;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ParseDirectoryListFromContentAndHeadersTest")
public class ParseDirectoryListFromContentAndHeadersTest
extends BaseHandlerTest {
    Function<HttpResponse, BoundedSet<DirectoryEntry>> createFn() {
        return (Function)this.injector.getInstance(ParseDirectoryListFromContentAndHeaders.class);
    }

    public void testWithToken() {
        HttpResponse response = ((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(Payloads.newPayload((Object)((Object)((Object)this)).getClass().getResourceAsStream("/list_basic.xml")))).addHeader("x-emc-token", new String[]{"token"})).build();
        BoundedSet result = (BoundedSet)this.createFn().apply((Object)response);
        Assert.assertEquals((Set)result, (Set)new BoundedLinkedHashSet(this.values(), "token"));
        Assert.assertEquals((String)result.getToken(), (String)"token");
    }

    public void testWithoutToken() {
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(Payloads.newPayload((Object)((Object)((Object)this)).getClass().getResourceAsStream("/list_basic.xml")))).build();
        BoundedSet result = (BoundedSet)this.createFn().apply((Object)response);
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)result), this.values());
        Assert.assertEquals((String)result.getToken(), null);
    }

    protected Set<DirectoryEntry> values() {
        ImmutableSet.Builder expected = ImmutableSet.builder();
        expected.add((Object)new DirectoryEntry("4980cdb2a411106a04a4538c92a1b204ad92077de6e3", FileType.DIRECTORY, "adriancole-blobstore-2096685753"));
        expected.add((Object)new DirectoryEntry("4980cdb2a410105404980d99e53a0504ad93939e7dc3", FileType.DIRECTORY, "adriancole-blobstore247496608"));
        return expected.build();
    }
}

