/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.functions;

import com.google.common.io.BaseEncoding;
import com.google.inject.Guice;
import com.google.inject.Module;
import org.jclouds.atmos.domain.FileType;
import org.jclouds.atmos.domain.SystemMetadata;
import org.jclouds.atmos.functions.ParseObjectFromHeadersAndHttpContentTest;
import org.jclouds.atmos.functions.ParseSystemMetadataFromHeaders;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseSystemMetadataFromHeadersTest {
    static final DateService dateService = new SimpleDateFormatDateService();
    static final SystemMetadata EXPECTED = new SystemMetadata(BaseEncoding.base16().lowerCase().decode((CharSequence)"1f3870be274f6c49b3e31a0c6728957f"), dateService.iso8601SecondsDateParse("2009-10-12T16:09:42Z"), dateService.iso8601SecondsDateParse("2009-10-19T04:37:00Z"), "rootr", dateService.iso8601SecondsDateParse("2009-10-12T16:09:42Z"), dateService.iso8601SecondsDateParse("2009-10-19T04:37:00Z"), 1, "4980cdb2b010109b04a44f7bb83f5f04ad354c638ae5", "e913e09366364e9ba384b8fead643d43", "default", 4096L, FileType.DIRECTORY, "root");

    public void test() {
        ParseSystemMetadataFromHeaders parser = (ParseSystemMetadataFromHeaders)Guice.createInjector((Module[])new Module[0]).getInstance(ParseSystemMetadataFromHeaders.class);
        SystemMetadata data = parser.apply(ParseObjectFromHeadersAndHttpContentTest.RESPONSE);
        Assert.assertEquals((Object)data, (Object)EXPECTED);
    }
}

