/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.atmos.AtmosAsyncClient;
import org.jclouds.atmos.blobstore.functions.BlobMetadataToObject;
import org.jclouds.atmos.blobstore.functions.BlobToObject;
import org.jclouds.atmos.blobstore.functions.ListOptionsToBlobStoreListOptions;
import org.jclouds.atmos.blobstore.functions.ObjectToBlob;
import org.jclouds.atmos.blobstore.functions.ResourceMetadataListToDirectoryEntryList;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.atmos.domain.BoundedSet;
import org.jclouds.atmos.domain.DirectoryEntry;
import org.jclouds.atmos.domain.SystemMetadata;
import org.jclouds.atmos.domain.UserMetadata;
import org.jclouds.atmos.options.ListOptions;
import org.jclouds.atmos.options.PutOptions;
import org.jclouds.blobstore.LocalAsyncBlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.functions.HttpGetOptionsListToGetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.http.options.GetOptions;
import org.jclouds.lifecycle.Closer;

public class StubAtmosAsyncClient
implements AtmosAsyncClient {
    private final HttpGetOptionsListToGetOptions httpGetOptionsConverter;
    private final LocalAsyncBlobStore blobStore;
    private final AtmosObject.Factory objectProvider;
    private final ObjectToBlob object2Blob;
    private final BlobToObject blob2Object;
    private final BlobMetadataToObject blob2ObjectInfo;
    private final ListOptionsToBlobStoreListOptions container2ContainerListOptions;
    private final ResourceMetadataListToDirectoryEntryList resource2ObjectList;
    private final ListeningExecutorService userExecutor;
    private final Closer closer;

    @Inject
    private StubAtmosAsyncClient(LocalAsyncBlobStore blobStore, AtmosObject.Factory objectProvider, HttpGetOptionsListToGetOptions httpGetOptionsConverter, ObjectToBlob object2Blob, BlobToObject blob2Object, BlobMetadataToObject blob2ObjectInfo, ListOptionsToBlobStoreListOptions container2ContainerListOptions, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, ResourceMetadataListToDirectoryEntryList resource2ContainerList, Closer closer) {
        this.blobStore = blobStore;
        this.objectProvider = objectProvider;
        this.httpGetOptionsConverter = httpGetOptionsConverter;
        this.object2Blob = (ObjectToBlob)Preconditions.checkNotNull((Object)object2Blob, (Object)"object2Blob");
        this.blob2Object = (BlobToObject)Preconditions.checkNotNull((Object)blob2Object, (Object)"blob2Object");
        this.blob2ObjectInfo = (BlobMetadataToObject)Preconditions.checkNotNull((Object)blob2ObjectInfo, (Object)"blob2ObjectInfo");
        this.container2ContainerListOptions = (ListOptionsToBlobStoreListOptions)Preconditions.checkNotNull((Object)container2ContainerListOptions, (Object)"container2ContainerListOptions");
        this.resource2ObjectList = (ResourceMetadataListToDirectoryEntryList)Preconditions.checkNotNull((Object)resource2ContainerList, (Object)"resource2ContainerList");
        this.userExecutor = userExecutor;
        this.closer = (Closer)Preconditions.checkNotNull((Object)closer, (Object)"closer");
    }

    public ListenableFuture<URI> createDirectory(String directoryName, PutOptions ... options) {
        String path;
        String container;
        if (directoryName.indexOf(47) != -1) {
            container = directoryName.substring(0, directoryName.indexOf(47));
            path = directoryName.substring(directoryName.indexOf(47) + 1);
        } else {
            container = directoryName;
            path = null;
        }
        return Futures.transform((ListenableFuture)this.blobStore.createContainerInLocation(null, container), (Function)new Function<Boolean, URI>(){

            public URI apply(Boolean from) {
                if (path != null) {
                    Blob blob = StubAtmosAsyncClient.this.blobStore.blobBuilder(path + "/").payload("").contentType("application/directory").build();
                    StubAtmosAsyncClient.this.blobStore.putBlob(container, blob);
                }
                return URI.create("http://stub/containers/" + container);
            }
        }, (Executor)this.userExecutor);
    }

    public ListenableFuture<URI> createFile(String parent, AtmosObject object, PutOptions ... options) {
        final String uri = "http://stub/containers/" + parent + "/" + object.getContentMetadata().getName();
        String file = object.getContentMetadata().getName();
        String container = parent;
        if (parent.indexOf(47) != -1) {
            container = parent.substring(0, parent.indexOf(47));
            String path = parent.substring(parent.indexOf(47) + 1);
            if (!path.equals("")) {
                object.getContentMetadata().setName(path + "/" + file);
            }
        }
        Blob blob = this.object2Blob.apply(object);
        return Futures.transform((ListenableFuture)this.blobStore.putBlob(container, blob), (Function)new Function<String, URI>(){

            public URI apply(String from) {
                return URI.create(uri);
            }
        }, (Executor)this.userExecutor);
    }

    public ListenableFuture<Void> deletePath(String path) {
        if (path.indexOf(47) == path.length() - 1) {
            return Futures.transform((ListenableFuture)this.blobStore.deleteContainerIfEmpty(path.substring(0, path.length() - 1)), (Function)new Function<Boolean, Void>(){

                public Void apply(Boolean from) {
                    return null;
                }
            }, (Executor)this.userExecutor);
        }
        String container = path.substring(0, path.indexOf(47));
        path = path.substring(path.indexOf(47) + 1);
        return this.blobStore.removeBlob(container, path);
    }

    public ListenableFuture<SystemMetadata> getSystemMetadata(String path) {
        throw new UnsupportedOperationException();
    }

    public ListenableFuture<UserMetadata> getUserMetadata(String path) {
        if (path.indexOf(47) == -1) {
            throw new UnsupportedOperationException();
        }
        String container = path.substring(0, path.indexOf(47));
        path = path.substring(path.indexOf(47) + 1);
        return Futures.transform((ListenableFuture)this.blobStore.blobMetadata(container, path), (Function)new Function<BlobMetadata, UserMetadata>(){

            public UserMetadata apply(BlobMetadata from) {
                return StubAtmosAsyncClient.this.blob2ObjectInfo.apply(from).getUserMetadata();
            }
        }, (Executor)this.userExecutor);
    }

    public ListenableFuture<AtmosObject> headFile(String path) {
        String container = path.substring(0, path.indexOf(47));
        path = path.substring(path.indexOf(47) + 1);
        try {
            return Futures.transform((ListenableFuture)this.blobStore.getBlob(container, path), (Function)this.blob2Object, (Executor)this.userExecutor);
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)Throwables.getRootCause((Throwable)e));
        }
    }

    public ListenableFuture<BoundedSet<? extends DirectoryEntry>> listDirectories(ListOptions ... optionsList) {
        return Futures.transform((ListenableFuture)this.blobStore.list(), (Function)this.resource2ObjectList, (Executor)this.userExecutor);
    }

    public ListenableFuture<BoundedSet<? extends DirectoryEntry>> listDirectory(String directoryName, ListOptions ... optionsList) {
        ListContainerOptions options = this.container2ContainerListOptions.apply(optionsList);
        String container = directoryName;
        if (directoryName.indexOf(47) != -1) {
            container = directoryName.substring(0, directoryName.indexOf(47));
            String path = directoryName.substring(directoryName.indexOf(47) + 1);
            if (!path.equals("")) {
                options.inDirectory(path);
            }
        }
        return Futures.transform((ListenableFuture)this.blobStore.list(container, options), (Function)this.resource2ObjectList, (Executor)this.userExecutor);
    }

    public AtmosObject newObject() {
        return this.objectProvider.create(null);
    }

    public ListenableFuture<Boolean> pathExists(String path) {
        if (path.indexOf(47) == path.length() - 1) {
            return this.blobStore.containerExists(path.substring(0, path.length() - 1));
        }
        String container = path.substring(0, path.indexOf(47));
        String blobName = path.substring(path.indexOf(47) + 1);
        try {
            return Futures.immediateFuture((Object)(this.blobStore.blobMetadata(container, blobName).get() != null ? 1 : 0));
        }
        catch (InterruptedException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
        catch (ExecutionException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public ListenableFuture<AtmosObject> readFile(String path, GetOptions ... options) {
        String container = path.substring(0, path.indexOf(47));
        String blobName = path.substring(path.indexOf(47) + 1);
        org.jclouds.blobstore.options.GetOptions getOptions = this.httpGetOptionsConverter.apply(options);
        return Futures.transform((ListenableFuture)this.blobStore.getBlob(container, blobName, getOptions), (Function)this.blob2Object, (Executor)this.userExecutor);
    }

    public ListenableFuture<Void> updateFile(String parent, AtmosObject object, PutOptions ... options) {
        throw new UnsupportedOperationException();
    }

    public ListenableFuture<Boolean> isPublic(String path) {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        this.closer.close();
    }
}

