/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.xml;

import com.google.common.collect.Sets;
import java.io.InputStream;
import java.util.Set;
import java.util.TreeSet;
import org.jclouds.atmos.domain.DirectoryEntry;
import org.jclouds.atmos.domain.FileType;
import org.jclouds.atmos.xml.ListDirectoryResponseHandler;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ListDirectoryResponseHandlerTest")
public class ListDirectoryResponseHandlerTest
extends BaseHandlerTest {
    ParseSax<Set<DirectoryEntry>> createParser() {
        ParseSax parser = this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(ListDirectoryResponseHandler.class));
        return parser;
    }

    public void testApplyInputStreamBase() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/list_basic.xml");
        ParseSax<Set<DirectoryEntry>> parser = this.createParser();
        TreeSet expected = Sets.newTreeSet();
        expected.add(new DirectoryEntry("4980cdb2a411106a04a4538c92a1b204ad92077de6e3", FileType.DIRECTORY, "adriancole-blobstore-2096685753"));
        expected.add(new DirectoryEntry("4980cdb2a410105404980d99e53a0504ad93939e7dc3", FileType.DIRECTORY, "adriancole-blobstore247496608"));
        Set result = (Set)parser.parse(is);
        Assert.assertEquals((Set)result, (Set)expected);
    }
}

