/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.atmos.AtmosAsyncClient;
import org.jclouds.atmos.AtmosClient;
import org.jclouds.atmos.blobstore.functions.BlobStoreListOptionsToListOptions;
import org.jclouds.atmos.blobstore.functions.BlobToObject;
import org.jclouds.atmos.blobstore.functions.DirectoryEntryListToResourceMetadataList;
import org.jclouds.atmos.blobstore.functions.ObjectToBlob;
import org.jclouds.atmos.blobstore.functions.ObjectToBlobMetadata;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.atmos.domain.BoundedSet;
import org.jclouds.atmos.domain.DirectoryEntry;
import org.jclouds.atmos.options.ListOptions;
import org.jclouds.atmos.options.PutOptions;
import org.jclouds.atmos.util.AtmosUtils;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.internal.BaseAsyncBlobStore;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.internal.FetchBlobMetadata;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.crypto.Crypto;
import org.jclouds.domain.Location;

@Deprecated
@Singleton
public class AtmosAsyncBlobStore
extends BaseAsyncBlobStore {
    private final AtmosAsyncClient async;
    private final AtmosClient sync;
    private final ObjectToBlob object2Blob;
    private final ObjectToBlobMetadata object2BlobMd;
    private final BlobToObject blob2Object;
    private final BlobStoreListOptionsToListOptions container2ContainerListOptions;
    private final DirectoryEntryListToResourceMetadataList container2ResourceList;
    private final Crypto crypto;
    private final BlobToHttpGetOptions blob2ObjectGetOptions;
    private final Provider<FetchBlobMetadata> fetchBlobMetadataProvider;
    private final LoadingCache<String, Boolean> isPublic;

    @Inject
    AtmosAsyncBlobStore(BlobStoreContext context, BlobUtils blobUtils, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, AtmosAsyncClient async, AtmosClient sync, ObjectToBlob object2Blob, ObjectToBlobMetadata object2BlobMd, BlobToObject blob2Object, BlobStoreListOptionsToListOptions container2ContainerListOptions, DirectoryEntryListToResourceMetadataList container2ResourceList, Crypto crypto, BlobToHttpGetOptions blob2ObjectGetOptions, Provider<FetchBlobMetadata> fetchBlobMetadataProvider, LoadingCache<String, Boolean> isPublic) {
        super(context, blobUtils, userExecutor, defaultLocation, locations);
        this.blob2ObjectGetOptions = (BlobToHttpGetOptions)Preconditions.checkNotNull((Object)blob2ObjectGetOptions, (Object)"blob2ObjectGetOptions");
        this.sync = (AtmosClient)Preconditions.checkNotNull((Object)sync, (Object)"sync");
        this.async = (AtmosAsyncClient)Preconditions.checkNotNull((Object)async, (Object)"async");
        this.container2ContainerListOptions = (BlobStoreListOptionsToListOptions)Preconditions.checkNotNull((Object)container2ContainerListOptions, (Object)"container2ContainerListOptions");
        this.container2ResourceList = (DirectoryEntryListToResourceMetadataList)Preconditions.checkNotNull((Object)container2ResourceList, (Object)"container2ResourceList");
        this.object2Blob = (ObjectToBlob)Preconditions.checkNotNull((Object)object2Blob, (Object)"object2Blob");
        this.blob2Object = (BlobToObject)Preconditions.checkNotNull((Object)blob2Object, (Object)"blob2Object");
        this.object2BlobMd = (ObjectToBlobMetadata)Preconditions.checkNotNull((Object)object2BlobMd, (Object)"object2BlobMd");
        this.crypto = (Crypto)Preconditions.checkNotNull((Object)crypto, (Object)"crypto");
        this.fetchBlobMetadataProvider = (Provider)Preconditions.checkNotNull(fetchBlobMetadataProvider, (Object)"fetchBlobMetadataProvider");
        this.isPublic = (LoadingCache)Preconditions.checkNotNull(isPublic, (Object)"isPublic");
    }

    public ListenableFuture<BlobMetadata> blobMetadata(String container, String key) {
        return Futures.transform(this.async.headFile(container + "/" + key), (Function)new Function<AtmosObject, BlobMetadata>(){

            public BlobMetadata apply(AtmosObject from) {
                return AtmosAsyncBlobStore.this.object2BlobMd.apply(from);
            }
        }, (Executor)this.userExecutor);
    }

    public ListenableFuture<Boolean> createContainerInLocation(Location location, String container) {
        return Futures.transform(this.async.createDirectory(container, new PutOptions[0]), (Function)new Function<URI, Boolean>(){

            public Boolean apply(URI from) {
                return from != null;
            }
        }, (Executor)this.userExecutor);
    }

    public ListenableFuture<Void> createDirectory(String container, String directory) {
        return Futures.transform(this.async.createDirectory(container + "/" + directory, new PutOptions[0]), (Function)new Function<URI, Void>(){

            public Void apply(URI from) {
                return null;
            }
        }, (Executor)this.userExecutor);
    }

    protected boolean deleteAndVerifyContainerGone(String container) {
        this.sync.deletePath(container + "/");
        return !this.sync.pathExists(container + "/");
    }

    public ListenableFuture<Boolean> containerExists(String container) {
        return this.async.pathExists(container + "/");
    }

    public ListenableFuture<Boolean> directoryExists(String container, String directory) {
        return this.async.pathExists(container + "/" + directory + "/");
    }

    public ListenableFuture<Void> deleteDirectory(String containerName, String directory) {
        return this.removeBlob(containerName, directory + "/");
    }

    public ListenableFuture<Boolean> blobExists(String container, String key) {
        return this.async.pathExists(container + "/" + key);
    }

    public ListenableFuture<Blob> getBlob(String container, String key, GetOptions options) {
        org.jclouds.http.options.GetOptions httpOptions = this.blob2ObjectGetOptions.apply(options);
        ListenableFuture<AtmosObject> returnVal = this.async.readFile(container + "/" + key, httpOptions);
        return Futures.transform(returnVal, (Function)this.object2Blob, (Executor)this.userExecutor);
    }

    public ListenableFuture<PageSet<? extends StorageMetadata>> list() {
        return Futures.transform(this.async.listDirectories(new ListOptions[0]), (Function)this.container2ResourceList, (Executor)this.userExecutor);
    }

    public ListenableFuture<PageSet<? extends StorageMetadata>> list(String container, ListContainerOptions options) {
        container = AtmosUtils.adjustContainerIfDirOptionPresent(container, options);
        ListOptions nativeOptions = this.container2ContainerListOptions.apply(options);
        ListenableFuture<BoundedSet<? extends DirectoryEntry>> returnVal = this.async.listDirectory(container, nativeOptions);
        ListenableFuture list = Futures.transform(returnVal, (Function)this.container2ResourceList, (Executor)this.userExecutor);
        return options.isDetailed() ? Futures.transform((ListenableFuture)list, (Function)((FetchBlobMetadata)this.fetchBlobMetadataProvider.get()).setContainerName(container)) : list;
    }

    public ListenableFuture<String> putBlob(final String container, final Blob blob) {
        final PutOptions options = new PutOptions();
        try {
            if (((Boolean)this.isPublic.getUnchecked((Object)(container + "/"))).booleanValue()) {
                options.publicRead();
            }
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            // empty catch block
        }
        return this.userExecutor.submit((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return AtmosUtils.putBlob(AtmosAsyncBlobStore.this.sync, AtmosAsyncBlobStore.this.crypto, AtmosAsyncBlobStore.this.blob2Object, container, blob, options);
            }

            public String toString() {
                return "putBlob(" + container + "," + blob.getMetadata().getName() + ")";
            }
        });
    }

    public ListenableFuture<Void> removeBlob(String container, String key) {
        return this.async.deletePath(container + "/" + key);
    }

    public ListenableFuture<String> putBlob(String container, Blob blob, org.jclouds.blobstore.options.PutOptions options) {
        return this.putBlob(container, blob);
    }

    public ListenableFuture<Boolean> createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        if (options.isPublicRead()) {
            return Futures.transform(this.async.createDirectory(container, PutOptions.Builder.publicRead()), (Function)new Function<URI, Boolean>(){

                public Boolean apply(URI from) {
                    return from != null;
                }
            }, (Executor)this.userExecutor);
        }
        return this.createContainerInLocation(location, container);
    }
}

