/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudfiles.binders;

import com.google.common.collect.ImmutableList;
import org.jclouds.cloudfiles.binders.BindIterableToHeadersWithPurgeCDNObjectEmail;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.swift.CommonSwiftClientTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BindIterableToHeadersWithPurgeCDNObjectEmailTest")
public class BindIterableToHeadersWithPurgeCDNObjectEmailTest
extends CommonSwiftClientTest {
    @Test
    public void testEmailBind() {
        ImmutableList emails = ImmutableList.of((Object)"foo@bar.com", (Object)"bar@foo.com");
        HttpRequest request = HttpRequest.builder().method("DELETE").endpoint("http://localhost").build();
        BindIterableToHeadersWithPurgeCDNObjectEmail binder = (BindIterableToHeadersWithPurgeCDNObjectEmail)this.injector.getInstance(BindIterableToHeadersWithPurgeCDNObjectEmail.class);
        HttpRequest actualRequest = binder.bindToRequest(request, (Object)emails);
        HttpRequest expectedRequest = ((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint("http://localhost").addHeader("X-Purge-Email", new String[]{"foo@bar.com, bar@foo.com"})).build();
        Assert.assertEquals((Object)actualRequest, (Object)expectedRequest);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullListIsBad() {
        HttpRequest request = HttpRequest.builder().method("DELETE").endpoint("http://localhost").build();
        BindIterableToHeadersWithPurgeCDNObjectEmail binder = (BindIterableToHeadersWithPurgeCDNObjectEmail)this.injector.getInstance(BindIterableToHeadersWithPurgeCDNObjectEmail.class);
        binder.bindToRequest(request, null);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullRequestIsBad() {
        ImmutableList emails = ImmutableList.of((Object)"foo@bar.com", (Object)"bar@foo.com");
        BindIterableToHeadersWithPurgeCDNObjectEmail binder = (BindIterableToHeadersWithPurgeCDNObjectEmail)this.injector.getInstance(BindIterableToHeadersWithPurgeCDNObjectEmail.class);
        binder.bindToRequest(null, (Object)emails);
    }
}

