/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudfiles.blobstore;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.blobstore.internal.BaseBlobSignerExpectTest;
import org.jclouds.cloudfiles.CloudFilesApiMetadata;
import org.jclouds.cloudfiles.blobstore.config.CloudFilesBlobStoreContextModule;
import org.jclouds.cloudfiles.config.CloudFilesRestClientModule;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="CloudFilesBlobSignerExpectTest")
public class CloudFilesBlobSignerExpectTest
extends BaseBlobSignerExpectTest {
    protected String authToken = "118fb907-0786-4799-88f0-9a5b7963d1ab";

    public CloudFilesBlobSignerExpectTest() {
        this.identity = "user@jclouds.org";
        this.credential = "Password1234";
    }

    protected HttpRequest getBlob() {
        return ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://storage101.lon3.clouddrive.com/v1/MossoCloudFS_83a9d536-2e25-4166-bd3b-a503a934f953/container/name").addHeader("X-Auth-Token", new String[]{this.authToken})).build();
    }

    protected HttpRequest getBlobWithTime() {
        return HttpRequest.builder().method("GET").endpoint("https://storage101.lon3.clouddrive.com/v1/MossoCloudFS_83a9d536-2e25-4166-bd3b-a503a934f953/container/name?temp_url_sig=9d62a4a15076699b3f7c60c2d021609990f24115&temp_url_expires=123456792").build();
    }

    protected HttpRequest getBlobWithOptions() {
        return ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://storage101.lon3.clouddrive.com/v1/MossoCloudFS_83a9d536-2e25-4166-bd3b-a503a934f953/container/name").addHeader("X-Auth-Token", new String[]{this.authToken})).addHeader("Range", new String[]{"bytes=0-1"})).build();
    }

    protected HttpRequest putBlob() {
        return ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("https://storage101.lon3.clouddrive.com/v1/MossoCloudFS_83a9d536-2e25-4166-bd3b-a503a934f953/container/name").addHeader("ETag", new String[]{"00020408"})).addHeader("Expect", new String[]{"100-continue"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
    }

    protected HttpRequest putBlobWithTime() {
        return ((HttpRequest.Builder)HttpRequest.builder().method("PUT").addHeader("Expect", new String[]{"100-continue"})).endpoint("https://storage101.lon3.clouddrive.com/v1/MossoCloudFS_83a9d536-2e25-4166-bd3b-a503a934f953/container/name?temp_url_sig=f83fa711f353f6f0bab3a66c56e35a972b9b3922&temp_url_expires=123456792").build();
    }

    protected HttpRequest removeBlob() {
        return ((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint("https://storage101.lon3.clouddrive.com/v1/MossoCloudFS_83a9d536-2e25-4166-bd3b-a503a934f953/container/name").addHeader("X-Auth-Token", new String[]{this.authToken})).build();
    }

    protected Map<HttpRequest, HttpResponse> init() {
        HttpRequest authRequest = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://auth.api.rackspacecloud.com/v1.1/auth").addHeader("Accept", new String[]{"application/json"})).payload(CloudFilesBlobSignerExpectTest.payloadFromStringWithContentType((String)"{\"credentials\":{\"username\":\"user@jclouds.org\",\"key\":\"Password1234\"}}", (String)"application/json"))).build();
        HttpResponse authResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("HTTP/1.1 200").payload(this.payloadFromResourceWithContentType("/auth1_1.json", "application/json"))).build();
        HttpRequest temporaryKeyRequest = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("HEAD").endpoint("https://storage101.lon3.clouddrive.com/v1/MossoCloudFS_83a9d536-2e25-4166-bd3b-a503a934f953/").addHeader("Accept", new String[]{"*/*"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse temporaryKeyResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).addHeader("X-Account-Meta-Temp-Url-Key", new String[]{"TEMPORARY_KEY"})).build();
        return ImmutableMap.builder().put((Object)authRequest, (Object)authResponse).put((Object)temporaryKeyRequest, (Object)temporaryKeyResponse).build();
    }

    protected ApiMetadata createApiMetadata() {
        return ((CloudFilesApiMetadata.Builder)((CloudFilesApiMetadata.Builder)new CloudFilesApiMetadata().toBuilder().defaultEndpoint("https://auth.api.rackspacecloud.com")).defaultModules((Set)ImmutableSet.builder().add(CloudFilesRestClientModule.StorageAndCDNManagementEndpointModule.class).add(CloudFilesRestClientModule.class).add(CloudFilesBlobStoreContextModule.class).add(StaticTimeAndTemporaryUrlKeyModule.class).build())).build();
    }

    public static class StaticTimeAndTemporaryUrlKeyModule
    extends CloudFilesApiMetadata.CloudFilesTemporaryUrlExtensionModule {
        protected Long unixEpochTimestampProvider() {
            return 123456789L;
        }
    }
}

