/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudfiles.functions;

import com.google.common.collect.ImmutableSortedSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import java.net.URI;
import java.util.Set;
import java.util.SortedSet;
import org.jclouds.cloudfiles.domain.ContainerCDNMetadata;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseContainerCDNMetadataListFromJsonResponseTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new GsonModule()});

    @Test
    public void testApplyInputStream() {
        InputStream is = this.getClass().getResourceAsStream("/test_list_cdn.json");
        ImmutableSortedSet expects = ImmutableSortedSet.of((Comparable)new ContainerCDNMetadata("adriancole-blobstore.testCDNOperationsContainerWithCDN", false, false, 3600L, URI.create("http://c0354712.cdn.cloudfiles.rackspacecloud.com"), URI.create("https://c0354712.cdn.ssl.cloudfiles.rackspacecloud.com"), URI.create("http://c0354712.cdn.stream.cloudfiles.rackspacecloud.com")), (Comparable)new ContainerCDNMetadata("adriancole-blobstore5", true, false, 28800L, URI.create("http://c0404671.cdn.cloudfiles.rackspacecloud.com"), URI.create("https://c0404671.cdn.ssl.cloudfiles.rackspacecloud.com"), URI.create("http://c0404671.cdn.stream.cloudfiles.rackspacecloud.com")), (Comparable)new ContainerCDNMetadata("adriancole-cfcdnint.testCDNOperationsContainerWithCDN", false, false, 3600L, URI.create("http://c0320431.cdn.cloudfiles.rackspacecloud.com"), URI.create("https://c0320431.cdn.ssl.cloudfiles.rackspacecloud.com"), URI.create("http://c0320431.cdn.stream.cloudfiles.rackspacecloud.com")));
        ParseJson parser = (ParseJson)this.i.getInstance(Key.get((TypeLiteral)new TypeLiteral<ParseJson<SortedSet<ContainerCDNMetadata>>>(){}));
        Assert.assertEquals((Set)((Set)parser.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(is)).build())), (Set)expects);
    }
}

