/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import org.jclouds.cloudservers.CloudServersClient;
import org.jclouds.cloudservers.internal.BaseCloudServersRestClientExpectTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="CloudServersExpectTest")
public class CloudServersExpectTest
extends BaseCloudServersRestClientExpectTest {
    public void deleteImageReturnsTrueOn200AndFalseOn404() {
        HttpRequest deleteImage11 = ((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint(URI.create("https://lon.servers.api.rackspacecloud.com/v1.0/10001786/images/11?now=1257695648897")).headers((Multimap)ImmutableMultimap.builder().put((Object)"X-Auth-Token", (Object)this.authToken).build())).build();
        HttpResponse imageDeleted = HttpResponse.builder().statusCode(204).message("HTTP/1.1 204 No Content").build();
        CloudServersClient clientWhenImageExists = (CloudServersClient)this.requestsSendResponses(this.initialAuth, this.responseWithAuth, deleteImage11, imageDeleted);
        assert (clientWhenImageExists.deleteImage(11));
        HttpResponse imageNotFound = HttpResponse.builder().statusCode(404).message("HTTP/1.1 404 Not Found").build();
        CloudServersClient clientWhenImageDoesntExist = (CloudServersClient)this.requestsSendResponses(this.initialAuth, this.responseWithAuth, deleteImage11, imageNotFound);
        assert (!clientWhenImageDoesntExist.deleteImage(11));
    }
}

