/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.functions;

import com.google.common.collect.ImmutableList;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseInetAddressListFromJsonResponseTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new GsonModule()});

    public void testPublic() throws UnknownHostException {
        InputStream is = this.getClass().getResourceAsStream("/test_list_addresses_public.json");
        UnwrapOnlyJsonValue parser = (UnwrapOnlyJsonValue)this.i.getInstance(Key.get((TypeLiteral)new TypeLiteral<UnwrapOnlyJsonValue<List<String>>>(){}));
        List response = (List)parser.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(is)).build());
        Assert.assertEquals((Collection)response, (Collection)ImmutableList.of((Object)"67.23.10.132", (Object)"67.23.10.131"));
    }

    public void testPrivate() throws UnknownHostException {
        InputStream is = this.getClass().getResourceAsStream("/test_list_addresses_private.json");
        UnwrapOnlyJsonValue parser = (UnwrapOnlyJsonValue)this.i.getInstance(Key.get((TypeLiteral)new TypeLiteral<UnwrapOnlyJsonValue<List<String>>>(){}));
        List response = (List)parser.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(is)).build());
        Assert.assertEquals((Collection)response, (Collection)ImmutableList.of((Object)"10.176.42.16"));
    }
}

