/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers;

import java.io.Closeable;
import java.util.Set;
import javax.ws.rs.PathParam;
import org.jclouds.cloudservers.domain.Addresses;
import org.jclouds.cloudservers.domain.BackupSchedule;
import org.jclouds.cloudservers.domain.Flavor;
import org.jclouds.cloudservers.domain.Image;
import org.jclouds.cloudservers.domain.Limits;
import org.jclouds.cloudservers.domain.RebootType;
import org.jclouds.cloudservers.domain.Server;
import org.jclouds.cloudservers.domain.SharedIpGroup;
import org.jclouds.cloudservers.options.CreateServerOptions;
import org.jclouds.cloudservers.options.CreateSharedIpGroupOptions;
import org.jclouds.cloudservers.options.ListOptions;
import org.jclouds.cloudservers.options.RebuildServerOptions;

public interface CloudServersClient
extends Closeable {
    public Limits getLimits();

    public Set<Server> listServers(ListOptions ... var1);

    public Server getServer(@PathParam(value="id") int var1);

    public boolean deleteServer(@PathParam(value="id") int var1);

    public void rebootServer(int var1, RebootType var2);

    public void resizeServer(int var1, int var2);

    public void confirmResizeServer(int var1);

    public void revertResizeServer(int var1);

    public Server createServer(String var1, int var2, int var3, CreateServerOptions ... var4);

    public void rebuildServer(int var1, RebuildServerOptions ... var2);

    public void shareIp(String var1, int var2, int var3, boolean var4);

    public void unshareIp(String var1, int var2);

    public void changeAdminPass(int var1, String var2);

    public void renameServer(int var1, String var2);

    public Set<Flavor> listFlavors(ListOptions ... var1);

    public Flavor getFlavor(int var1);

    public Set<Image> listImages(ListOptions ... var1);

    public Image getImage(int var1);

    public boolean deleteImage(int var1);

    public Image createImageFromServer(String var1, int var2);

    public Set<SharedIpGroup> listSharedIpGroups(ListOptions ... var1);

    public SharedIpGroup getSharedIpGroup(int var1);

    public SharedIpGroup createSharedIpGroup(String var1, CreateSharedIpGroupOptions ... var2);

    public boolean deleteSharedIpGroup(int var1);

    public BackupSchedule getBackupSchedule(int var1);

    public boolean deleteBackupSchedule(int var1);

    public void replaceBackupSchedule(int var1, BackupSchedule var2);

    public Addresses getAddresses(int var1);

    public Set<String> listPublicAddresses(int var1);

    public Set<String> listPrivateAddresses(int var1);
}

