/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.extensions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.inject.Module;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.internal.BaseCloudStackComputeServiceContextExpectTest;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageTemplate;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="CloudStackImageExtensionExpectTest")
public class CloudStackImageExtensionExpectTest
extends BaseCloudStackComputeServiceContextExpectTest<ComputeService> {
    protected Properties setupProperties() {
        Properties overrides = super.setupProperties();
        overrides.setProperty("jclouds.zones", "MTV-Zone1");
        return overrides;
    }

    public void testCreateImage() {
        HttpRequest listVM = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listVirtualMachines"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("id", new String[]{"3239ade9-fd25-405c-8eda-59f0313a3fb0"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"Qq7Br3qNsyr5ifWZHIrLAslhwm0%3D"}).addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse listVMResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listvirtualmachinesresponse-imageextension.json"))).build();
        HttpRequest stopVM = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"stopVirtualMachine"}).addQueryParam("id", new String[]{"3239ade9-fd25-405c-8eda-59f0313a3fb0"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"y9vxRK61K8sDoWtvSJHIx5WO9AE%3D"}).addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse stopVMResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/stopvirtualmachineresponse-imageextension.json"))).build();
        HttpRequest stopAsyncJobResult = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"queryAsyncJobResult"}).addQueryParam("jobid", new String[]{"a7d5127b-24a2-4a44-a4a7-25a6d057b453"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"CVpnN%2FSbx%2FMCOOyj%2FoVAt3bn684%3D"}).addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse stopAsyncJobResultResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/queryasyncjobresultresponse-stopvirtualmachine-imageextension.json"))).build();
        HttpRequest listVolumes = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listVolumes"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("virtualmachineid", new String[]{"3239ade9-fd25-405c-8eda-59f0313a3fb0"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"drLPf9NE9ROZPOfeDkASiKa50t8%3D"}).addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse listVolumesResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listvolumesresponse-imageextension.json"))).build();
        HttpRequest createTemplate = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"createTemplate"}).addQueryParam("volumeid", new String[]{"fe1ada16-57a0-40ae-b577-01a153690fb4"}).addQueryParam("name", new String[]{"temp-template-ignore"}).addQueryParam("ostypeid", new String[]{"45de18f1-87c6-4646-8099-95c61f2a300a"}).addQueryParam("displaytext", new String[]{"temp-template-ignore"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"madHsBgxjYbM6JnZKYWajOlfPlY%3D"}).addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse createTemplateResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/createtemplateresponse-imageextension.json"))).build();
        HttpRequest createAsyncJobResult = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"queryAsyncJobResult"}).addQueryParam("jobid", new String[]{"4e345230-8fcc-48a3-8a37-c5fe960df671"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"6mTKL9fjz7bn6C7tOaZBzKdZwHs%3D"}).addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse createAsyncJobResultResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/queryasyncjobresultresponse-createtemplate-imageextension.json"))).build();
        HttpRequest getTemplate = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"listTemplates"}).addQueryParam("listAll", new String[]{"true"}).addQueryParam("templatefilter", new String[]{"executable"}).addQueryParam("id", new String[]{"3dc6ce25-a6cf-4d60-a664-3499993b511b"}).addQueryParam("apiKey", new String[]{"APIKEY"}).addQueryParam("signature", new String[]{"dXv%2Bl04EDd7hmrWv5CdW8v298RE%3D"}).addHeader("Accept", new String[]{"application/json"})).build();
        HttpResponse getTemplateResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listtemplatesresponse-imageextension.json"))).build();
        ImmutableMap requestResponseMap = ImmutableMap.builder().put((Object)this.listTemplates, (Object)this.listTemplatesResponse).put((Object)this.listOsTypes, (Object)this.listOsTypesResponse).put((Object)this.listOsCategories, (Object)this.listOsCategoriesResponse).put((Object)this.listZones, (Object)this.listZonesResponse).put((Object)this.listServiceOfferings, (Object)this.listServiceOfferingsResponse).put((Object)this.listAccounts, (Object)this.listAccountsResponse).put((Object)this.listNetworks, (Object)this.listNetworksResponse).put((Object)this.getZone, (Object)this.getZoneResponse).put((Object)listVM, (Object)listVMResponse).put((Object)stopVM, (Object)stopVMResponse).put((Object)stopAsyncJobResult, (Object)stopAsyncJobResultResponse).put((Object)listVolumes, (Object)listVolumesResponse).put((Object)createTemplate, (Object)createTemplateResponse).put((Object)createAsyncJobResult, (Object)createAsyncJobResultResponse).put((Object)getTemplate, (Object)getTemplateResponse).build();
        ImageExtension apiThatCreatesImage = (ImageExtension)((ComputeService)this.requestsSendResponses((Map)requestResponseMap)).getImageExtension().get();
        ImageTemplate newImageTemplate = apiThatCreatesImage.buildImageTemplateFromNode("temp-template-ignore", "3239ade9-fd25-405c-8eda-59f0313a3fb0");
        Image image = (Image)Futures.getUnchecked((Future)apiThatCreatesImage.createImage(newImageTemplate));
        Assert.assertEquals((String)image.getId(), (String)"3dc6ce25-a6cf-4d60-a664-3499993b511b");
    }

    @Override
    public ComputeService createClient(Function<HttpRequest, HttpResponse> fn, Module module, Properties props) {
        return this.clientFrom((CloudStackContext)this.createInjector(fn, module, props).getInstance(CloudStackContext.class));
    }

    @Override
    protected ComputeService clientFrom(CloudStackContext context) {
        return context.getComputeService();
    }
}

