/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.features.GlobalAccountAsyncClient;
import org.jclouds.cloudstack.internal.BaseCloudStackAsyncClientTest;
import org.jclouds.cloudstack.options.CreateAccountOptions;
import org.jclouds.cloudstack.options.UpdateAccountOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GlobalAccountAsyncClientTest")
public class GlobalAccountAsyncClientTest
extends BaseCloudStackAsyncClientTest<GlobalAccountAsyncClient> {
    HttpRequest create = HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"createAccount"}).addQueryParam("username", new String[]{"user"}).addQueryParam("accounttype", new String[]{"0"}).addQueryParam("email", new String[]{"email@example.com"}).addQueryParam("firstname", new String[]{"FirstName"}).addQueryParam("lastname", new String[]{"LastName"}).addQueryParam("password", new String[]{"hashed-password"}).build();
    HttpRequest update = HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"updateAccount"}).addQueryParam("account", new String[]{"account"}).addQueryParam("domainid", new String[]{"42"}).addQueryParam("newname", new String[]{"new-account-name"}).build();

    public void testCreateAccount() throws Exception {
        Invokable method = Reflection2.method(GlobalAccountAsyncClient.class, (String)"createAccount", (Class[])new Class[]{String.class, Account.Type.class, String.class, String.class, String.class, String.class, CreateAccountOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"user", (Object)Account.Type.USER, (Object)"email@example.com", (Object)"FirstName", (Object)"LastName", (Object)"hashed-password"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, this.create.getRequestLine());
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testUpdateAccount() throws Exception {
        Invokable method = Reflection2.method(GlobalAccountAsyncClient.class, (String)"updateAccount", (Class[])new Class[]{String.class, String.class, String.class, UpdateAccountOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"account", (Object)42L, (Object)"new-account-name"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, this.update.getRequestLine());
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDeleteAccount() throws Exception {
        Invokable method = Reflection2.method(GlobalAccountAsyncClient.class, (String)"deleteAccount", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)42L));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=deleteAccount&id=42 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }
}

