/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Strings;
import java.util.Set;
import org.jclouds.cloudstack.domain.StoragePool;
import org.jclouds.cloudstack.internal.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.ListStoragePoolsOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="GlobalStoragePoolClientLiveTest")
public class GlobalStoragePoolClientLiveTest
extends BaseCloudStackClientLiveTest {
    @Test(groups={"live"}, enabled=true)
    public void testListStoragePools() throws Exception {
        this.skipIfNotGlobalAdmin();
        Set result = this.globalAdminClient.getStoragePoolClient().listStoragePools(new ListStoragePoolsOptions[0]);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.size() > 0 ? 1 : 0) != 0);
        for (StoragePool pool : result) {
            Assert.assertNotNull((Object)pool.getId());
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)pool.getName()));
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)pool.getPath()));
            Assert.assertNotNull((Object)pool.getTags());
            Assert.assertNotEquals((Object)StoragePool.State.UNRECOGNIZED, (Object)pool.getState());
            Assert.assertNotEquals((Object)StoragePool.Type.UNRECOGNIZED, (Object)pool.getType());
            Assert.assertNotNull((Object)pool.getZoneId());
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)pool.getZoneName()));
            Assert.assertNotNull((Object)pool.getPodId());
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)pool.getPodName()));
            Assert.assertNotNull((Object)pool.getClusterId());
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)pool.getClusterName()));
            Assert.assertNotNull((Object)pool.getCreated());
            Assert.assertTrue((pool.getDiskSizeTotal() > 0L ? 1 : 0) != 0);
        }
    }
}

