/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.jclouds.cloudstack.features.GlobalUsageAsyncClient;
import org.jclouds.cloudstack.internal.BaseCloudStackAsyncClientTest;
import org.jclouds.cloudstack.options.GenerateUsageRecordsOptions;
import org.jclouds.cloudstack.options.ListUsageRecordsOptions;
import org.jclouds.fallbacks.MapHttp4xxCodesToExceptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GlobalUsageAsyncClientTest")
public class GlobalUsageAsyncClientTest
extends BaseCloudStackAsyncClientTest<GlobalUsageAsyncClient> {
    public void testGenerateUsageRecords() throws Exception {
        Calendar c = Calendar.getInstance();
        c.set(1, 2012);
        c.set(2, 0);
        c.set(5, 1);
        Date start = c.getTime();
        c.set(5, 31);
        Date end = c.getTime();
        Invokable method = Reflection2.method(GlobalUsageAsyncClient.class, (String)"generateUsageRecords", (Class[])new Class[]{Date.class, Date.class, GenerateUsageRecordsOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)start, (Object)end));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=generateUsageRecords&startdate=2012-01-01&enddate=2012-01-31 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGenerateUsageRecordsOptions() throws Exception {
        Calendar c = Calendar.getInstance();
        c.set(1, 2012);
        c.set(2, 0);
        c.set(5, 1);
        Date start = c.getTime();
        c.set(5, 31);
        Date end = c.getTime();
        Invokable method = Reflection2.method(GlobalUsageAsyncClient.class, (String)"generateUsageRecords", (Class[])new Class[]{Date.class, Date.class, GenerateUsageRecordsOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)start, (Object)end, (Object)GenerateUsageRecordsOptions.Builder.domainId((String)"42")));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=generateUsageRecords&startdate=2012-01-01&enddate=2012-01-31&domainid=42 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListUsageRecords() throws Exception {
        Calendar c = Calendar.getInstance();
        c.set(1, 2012);
        c.set(2, 0);
        c.set(5, 1);
        Date start = c.getTime();
        c.set(5, 31);
        Date end = c.getTime();
        Invokable method = Reflection2.method(GlobalUsageAsyncClient.class, (String)"listUsageRecords", (Class[])new Class[]{Date.class, Date.class, ListUsageRecordsOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)start, (Object)end));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listUsageRecords&listAll=true&startdate=2012-01-01&enddate=2012-01-31 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListUsageRecordsOptions() throws Exception {
        Calendar c = Calendar.getInstance();
        c.set(1, 2012);
        c.set(2, 0);
        c.set(5, 1);
        Date start = c.getTime();
        c.set(5, 31);
        Date end = c.getTime();
        Invokable method = Reflection2.method(GlobalUsageAsyncClient.class, (String)"listUsageRecords", (Class[])new Class[]{Date.class, Date.class, ListUsageRecordsOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)start, (Object)end, (Object)ListUsageRecordsOptions.Builder.accountInDomain((String)"fred", (String)"42").accountId("41").keyword("bob")));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/client/api?response=json&command=listUsageRecords&listAll=true&startdate=2012-01-01&enddate=2012-01-31&account=fred&domainid=42&accountid=41&keyword=bob HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseFirstJsonValueNamed.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }
}

