/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.jclouds.cloudstack.domain.ISO;
import org.jclouds.cloudstack.domain.ISOPermissions;
import org.jclouds.cloudstack.domain.OSType;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.internal.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.AccountInDomainOptions;
import org.jclouds.cloudstack.options.DeleteISOOptions;
import org.jclouds.cloudstack.options.ListISOsOptions;
import org.jclouds.cloudstack.options.ListOSTypesOptions;
import org.jclouds.cloudstack.options.ListZonesOptions;
import org.jclouds.cloudstack.options.RegisterISOOptions;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="ISOClientLiveTest")
public class ISOClientLiveTest
extends BaseCloudStackClientLiveTest {
    private static final String isoName = "jcloudsTestISO";
    private static final String url = System.getProperty("test.cloudstack.iso-url", "http://archive.ubuntu.com/ubuntu/dists/maverick/main/installer-i386/current/images/netboot/mini.iso");

    public void testListPublicISOs() throws Exception {
        Set response = this.client.getISOClient().listISOs(new ListISOsOptions[]{ListISOsOptions.Builder.isPublic()});
        Assert.assertNotNull((Object)response);
        Assert.assertFalse((boolean)response.isEmpty());
        long isoCount = response.size();
        Assert.assertTrue((isoCount >= 0L ? 1 : 0) != 0);
        for (ISO iso : response) {
            ISO query = this.client.getISOClient().getISO(iso.getId());
            Assert.assertEquals((String)query.getId(), (String)iso.getId());
        }
    }

    public void testListISOPermissions() throws Exception {
        Set response = this.client.getISOClient().listISOs(new ListISOsOptions[]{ListISOsOptions.Builder.isPublic()});
        Assert.assertNotNull((Object)response);
        Assert.assertFalse((boolean)response.isEmpty());
        long isoCount = response.size();
        Assert.assertTrue((isoCount >= 0L ? 1 : 0) != 0);
        for (ISO iso : response) {
            ISOPermissions perms = this.client.getISOClient().listISOPermissions(iso.getId(), new AccountInDomainOptions[0]);
            Assert.assertNotNull((Object)perms);
        }
    }

    public void testRegisterISO() throws Exception {
        Optional guestOSTypeOptional = Iterables.tryFind((Iterable)this.client.getGuestOSClient().listOSTypes(new ListOSTypesOptions[0]), (Predicate)Predicates.notNull());
        Optional zoneOptional = Iterables.tryFind((Iterable)this.client.getZoneClient().listZones(new ListZonesOptions[]{ListZonesOptions.Builder.available((boolean)true)}), (Predicate)Predicates.notNull());
        if (!guestOSTypeOptional.isPresent() || !zoneOptional.isPresent()) {
            String skipMessage = String.format("Cannot register the iso with url: %s", url);
            skipMessage = zoneOptional.isPresent() ? skipMessage + " without a valid zone" : skipMessage + " without a valid guest OS type";
            throw new SkipException(skipMessage);
        }
        String osTypeId = ((OSType)guestOSTypeOptional.get()).getId();
        String zoneId = ((Zone)zoneOptional.get()).getId();
        ISO iso = this.client.getISOClient().registerISO(isoName, "", url, zoneId, new RegisterISOOptions[]{RegisterISOOptions.Builder.isPublic((boolean)true).osTypeId(osTypeId)});
        Assert.assertNotNull((Object)iso);
        Assert.assertNotNull((Object)iso.getId());
        Assert.assertEquals((String)iso.getName(), (String)isoName);
    }

    @AfterClass
    protected void tearDownContext() {
        Set isos = this.client.getISOClient().listISOs(new ListISOsOptions[]{ListISOsOptions.Builder.name((String)isoName)});
        for (ISO iso : isos) {
            this.client.getISOClient().deleteISO(iso.getId(), new DeleteISOOptions[]{DeleteISOOptions.NONE});
        }
        super.tearDownContext();
    }
}

