/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.net.URI;
import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.domain.ApiKeyPair;
import org.jclouds.cloudstack.domain.LoginResponse;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.cloudstack.features.GlobalAccountClientLiveTest;
import org.jclouds.cloudstack.features.GlobalUserClientLiveTest;
import org.jclouds.cloudstack.internal.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.util.ApiKeyPairs;
import org.jclouds.rest.AuthorizationException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="SessionClientLiveTest")
public class SessionClientLiveTest
extends BaseCloudStackClientLiveTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateContextUsingUserAndPasswordAuthentication() {
        this.skipIfNotGlobalAdmin();
        Account testAccount = null;
        User testUser = null;
        String prefix = this.prefix + "-session";
        try {
            testAccount = GlobalAccountClientLiveTest.createTestAccount(this.globalAdminClient, prefix);
            testUser = GlobalUserClientLiveTest.createTestUser(this.globalAdminClient, testAccount, prefix);
            String expectedUsername = prefix + "-user";
            Assert.assertEquals((String)testUser.getName(), (String)expectedUsername);
            this.checkLoginAsTheNewUser(expectedUsername);
            ApiKeyPair expected = this.globalAdminClient.getUserClient().registerUserKeys(testUser.getId());
            ApiKeyPair actual = ApiKeyPairs.loginToEndpointAsUsernameInDomainWithPasswordAndReturnApiKeyPair((URI)URI.create(this.endpoint), (String)(prefix + "-user"), (String)"password", (String)"");
            Assert.assertEquals((Object)actual, (Object)expected);
        }
        finally {
            if (testUser != null) {
                this.globalAdminClient.getUserClient().deleteUser(testUser.getId());
            }
            if (testAccount != null) {
                this.globalAdminClient.getAccountClient().deleteAccount(testAccount.getId());
            }
        }
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testTryToGetApiKeypairWithWrongCredentials() {
        ApiKeyPairs.loginToEndpointAsUsernameInDomainWithPasswordAndReturnApiKeyPair((URI)URI.create(this.endpoint), (String)"dummy-missing-user", (String)"with-a-wrong-password", (String)"");
    }

    private void checkLoginAsTheNewUser(String expectedUsername) {
        LoginResponse response = this.globalAdminClient.getSessionClient().loginUserInDomainWithHashOfPassword(expectedUsername, "", BaseEncoding.base16().lowerCase().encode(Hashing.md5().hashString((CharSequence)"password", Charsets.UTF_8).asBytes()));
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getSessionKey());
        Assert.assertNotNull((Object)response.getJSessionId());
        this.client.getSessionClient().logoutUser(response.getSessionKey());
    }
}

