/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.net.HostAndPort;
import com.google.common.net.HostSpecifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.AsyncJob;
import org.jclouds.cloudstack.domain.GuestIPType;
import org.jclouds.cloudstack.domain.NIC;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.NetworkOffering;
import org.jclouds.cloudstack.domain.SecurityGroup;
import org.jclouds.cloudstack.domain.ServiceOffering;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.internal.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.CreateNetworkOptions;
import org.jclouds.cloudstack.options.DeployVirtualMachineOptions;
import org.jclouds.cloudstack.options.ListNetworkOfferingsOptions;
import org.jclouds.cloudstack.options.ListNetworksOptions;
import org.jclouds.cloudstack.options.ListSecurityGroupsOptions;
import org.jclouds.cloudstack.options.ListServiceOfferingsOptions;
import org.jclouds.cloudstack.options.ListTemplatesOptions;
import org.jclouds.cloudstack.options.ListVirtualMachinesOptions;
import org.jclouds.cloudstack.options.ListZonesOptions;
import org.jclouds.util.InetAddresses2;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="VirtualMachineClientLiveTest")
public class VirtualMachineClientLiveTest
extends BaseCloudStackClientLiveTest {
    private static final Logger logger = Logger.getAnonymousLogger();
    private VirtualMachine vm = null;
    static final Ordering<ServiceOffering> DEFAULT_SIZE_ORDERING = new Ordering<ServiceOffering>(){

        public int compare(ServiceOffering left, ServiceOffering right) {
            return ComparisonChain.start().compare(left.getCpuNumber(), right.getCpuNumber()).compare(left.getMemory(), right.getMemory()).result();
        }
    };

    public static VirtualMachine createVirtualMachine(CloudStackClient client, String defaultTemplate, Predicate<String> jobComplete, Predicate<VirtualMachine> virtualMachineRunning) {
        Set networks = client.getNetworkClient().listNetworks(new ListNetworksOptions[]{ListNetworksOptions.Builder.isDefault((boolean)true)});
        if (networks.size() > 0) {
            Network network = (Network)Iterables.get((Iterable)Sets.filter((Set)networks, (Predicate)new Predicate<Network>(){

                public boolean apply(Network network) {
                    return network != null && network.getState().equals("Implemented");
                }
            }), (int)0);
            return VirtualMachineClientLiveTest.createVirtualMachineInNetwork(network, VirtualMachineClientLiveTest.defaultTemplateOrPreferredInZone(defaultTemplate, client, network.getZoneId()), client, jobComplete, virtualMachineRunning);
        }
        String zoneId = ((Zone)Iterables.find((Iterable)client.getZoneClient().listZones(new ListZonesOptions[0]), (Predicate)new Predicate<Zone>(){

            public boolean apply(Zone arg0) {
                return arg0.isSecurityGroupsEnabled();
            }
        })).getId();
        return VirtualMachineClientLiveTest.createVirtualMachineWithSecurityGroupInZone(zoneId, VirtualMachineClientLiveTest.defaultTemplateOrPreferredInZone(defaultTemplate, client, zoneId), ((SecurityGroup)Iterables.get((Iterable)client.getSecurityGroupClient().listSecurityGroups(new ListSecurityGroupsOptions[0]), (int)0)).getId(), client, jobComplete, virtualMachineRunning);
    }

    public static VirtualMachine createVirtualMachineWithSecurityGroupInZone(String zoneId, String templateId, String groupId, CloudStackClient client, Predicate<String> jobComplete, Predicate<VirtualMachine> virtualMachineRunning) {
        return VirtualMachineClientLiveTest.createVirtualMachineWithOptionsInZone(new DeployVirtualMachineOptions().securityGroupId(groupId), zoneId, templateId, client, jobComplete, virtualMachineRunning);
    }

    public static VirtualMachine createVirtualMachineInNetwork(Network network, String templateId, CloudStackClient client, Predicate<String> jobComplete, Predicate<VirtualMachine> virtualMachineRunning) {
        DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
        String zoneId = network.getZoneId();
        options.networkId(network.getId());
        return VirtualMachineClientLiveTest.createVirtualMachineWithOptionsInZone(options, zoneId, templateId, client, jobComplete, virtualMachineRunning);
    }

    public static VirtualMachine createVirtualMachineInNetworkWithIp(CloudStackClient client, String templateId, Set<Network> networks, Map<String, String> ipToNetwork, Predicate<String> jobComplete, Predicate<VirtualMachine> virtualMachineRunning) {
        DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
        String zoneId = ((Network)Iterables.getFirst(networks, null)).getZoneId();
        options.networkIds(Iterables.transform(networks, (Function)new Function<Network, String>(){

            public String apply(Network network) {
                return network.getId();
            }
        }));
        options.ipsToNetworks(ipToNetwork);
        return VirtualMachineClientLiveTest.createVirtualMachineWithOptionsInZone(options, zoneId, templateId, client, jobComplete, virtualMachineRunning);
    }

    public static VirtualMachine createVirtualMachineWithOptionsInZone(DeployVirtualMachineOptions options, String zoneId, String templateId, CloudStackClient client, Predicate<String> jobComplete, Predicate<VirtualMachine> virtualMachineRunning) {
        VirtualMachine vm;
        String serviceOfferingId = ((ServiceOffering)DEFAULT_SIZE_ORDERING.min((Iterable)client.getOfferingClient().listServiceOfferings(new ListServiceOfferingsOptions[0]))).getId();
        System.out.printf("serviceOfferingId %s, templateId %s, zoneId %s, options %s%n", serviceOfferingId, templateId, zoneId, options);
        AsyncCreateResponse job = client.getVirtualMachineClient().deployVirtualMachineInZone(zoneId, serviceOfferingId, templateId, new DeployVirtualMachineOptions[]{options});
        Assert.assertTrue((boolean)jobComplete.apply((Object)job.getJobId()));
        AsyncJob jobWithResult = client.getAsyncJobClient().getAsyncJob(job.getJobId());
        if (jobWithResult.getError() != null) {
            Throwables.propagate((Throwable)new ExecutionException(String.format("job %s failed with exception %s", job.getId(), jobWithResult.getError().toString())){});
        }
        if ((vm = (VirtualMachine)jobWithResult.getResult()).isPasswordEnabled()) assert (vm.getPassword() != null) : vm;
        Assert.assertTrue((boolean)virtualMachineRunning.apply((Object)vm));
        Assert.assertEquals((String)vm.getServiceOfferingId(), (String)serviceOfferingId);
        Assert.assertEquals((String)vm.getTemplateId(), (String)templateId);
        Assert.assertEquals((String)vm.getZoneId(), (String)zoneId);
        return vm;
    }

    @Test
    public void testCreateVirtualMachine() throws Exception {
        String defaultTemplate = this.template != null ? this.template.getImageId() : null;
        this.vm = VirtualMachineClientLiveTest.createVirtualMachine(this.client, defaultTemplate, (Predicate<String>)this.jobComplete, (Predicate<VirtualMachine>)this.virtualMachineRunning);
        if (this.vm.getPassword() != null) {
            this.conditionallyCheckSSH();
        }
        assert (Predicates.in((Collection)ImmutableSet.of((Object)"NetworkFilesystem", (Object)"IscsiLUN", (Object)"VMFS", (Object)"PreSetup", (Object)"ROOT")).apply((Object)this.vm.getRootDeviceType())) : this.vm;
        this.checkVm(this.vm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateVirtualMachineWithSpecificIp() throws Exception {
        this.skipIfNotGlobalAdmin();
        String defaultTemplate = this.template != null ? this.template.getImageId() : null;
        Network network = null;
        try {
            Template template = (Template)Iterables.getOnlyElement((Iterable)this.client.getTemplateClient().listTemplates(ListTemplatesOptions.Builder.id((String)defaultTemplate)));
            logger.info("Using template: " + template);
            Set allSafeNetworksInZone = this.adminClient.getNetworkClient().listNetworks(new ListNetworksOptions[]{ListNetworksOptions.Builder.zoneId((String)template.getZoneId()).isSystem(false)});
            for (Network net : allSafeNetworksInZone) {
                if (!net.getName().equals(this.prefix + "-ip-network")) continue;
                logger.info("Deleting VMs in network: " + net);
                Set machinesInNetwork = this.adminClient.getVirtualMachineClient().listVirtualMachines(new ListVirtualMachinesOptions[]{ListVirtualMachinesOptions.Builder.networkId((String)net.getId())});
                for (VirtualMachine machine : machinesInNetwork) {
                    if (!machine.getState().equals((Object)VirtualMachine.State.RUNNING)) continue;
                    logger.info("Deleting VM: " + machine);
                    this.destroyMachine(machine);
                }
                Assert.assertTrue((boolean)this.adminJobComplete.apply((Object)this.adminClient.getNetworkClient().deleteNetwork(net.getId())), (String)net.toString());
            }
            NetworkOffering offering = (NetworkOffering)Iterables.getFirst((Iterable)this.client.getOfferingClient().listNetworkOfferings(new ListNetworkOfferingsOptions[]{ListNetworkOfferingsOptions.Builder.zoneId((String)template.getZoneId()).specifyVLAN(true)}), null);
            Preconditions.checkNotNull((Object)offering, (Object)"No network offering found");
            logger.info("Using network offering: " + offering);
            network = this.adminClient.getNetworkClient().createNetworkInZone(template.getZoneId(), offering.getId(), this.prefix + "-ip-network", "", new CreateNetworkOptions[]{CreateNetworkOptions.Builder.startIP((String)"192.168.0.1").endIP("192.168.0.5").netmask("255.255.255.0").gateway("192.168.0.1").vlan("21")});
            logger.info("Created network: " + network);
            Network requiredNetwork = (Network)Iterables.getOnlyElement((Iterable)Sets.filter((Set)this.adminClient.getNetworkClient().listNetworks(new ListNetworksOptions[]{ListNetworksOptions.Builder.zoneId((String)template.getZoneId())}), (Predicate)new Predicate<Network>(){

                public boolean apply(Network network) {
                    return network.isDefault() && network.getGuestIPType() == GuestIPType.VIRTUAL;
                }
            }));
            logger.info("Required network: " + requiredNetwork);
            String ipAddress = "192.168.0.4";
            HashMap ipsToNetworks = Maps.newHashMap();
            ipsToNetworks.put(ipAddress, network.getId());
            this.vm = VirtualMachineClientLiveTest.createVirtualMachineInNetworkWithIp(this.adminClient, defaultTemplate, (Set<Network>)ImmutableSet.of((Object)requiredNetwork, (Object)network), ipsToNetworks, (Predicate<String>)this.adminJobComplete, (Predicate<VirtualMachine>)this.adminVirtualMachineRunning);
            logger.info("Created VM: " + this.vm);
            boolean hasStaticIpNic = false;
            for (NIC nic : this.vm.getNICs()) {
                if (nic.getNetworkId() != network.getId()) continue;
                hasStaticIpNic = true;
                Assert.assertEquals((String)nic.getIPAddress(), (String)ipAddress);
            }
            assert (hasStaticIpNic);
            this.checkVm(this.vm);
        }
        finally {
            if (this.vm != null) {
                this.destroyMachine(this.vm);
                this.vm = null;
            }
            if (network != null) {
                String jobId = this.adminClient.getNetworkClient().deleteNetwork(network.getId());
                this.adminJobComplete.apply((Object)jobId);
                network = null;
            }
        }
    }

    private void destroyMachine(VirtualMachine virtualMachine) {
        Assert.assertTrue((boolean)this.adminJobComplete.apply((Object)this.adminClient.getVirtualMachineClient().destroyVirtualMachine(virtualMachine.getId())), (String)virtualMachine.toString());
        Assert.assertTrue((boolean)this.adminVirtualMachineDestroyed.apply((Object)virtualMachine));
    }

    private void conditionallyCheckSSH() {
        if (this.vm.getPassword() != null && this.loginCredentials.getOptionalPassword() == null) {
            this.loginCredentials = this.loginCredentials.toBuilder().password(this.vm.getPassword()).build();
        }
        assert (HostSpecifier.isValid((String)this.vm.getIPAddress()));
        if (!InetAddresses2.isPrivateIPAddress((String)this.vm.getIPAddress())) {
            HostAndPort socket = HostAndPort.fromParts((String)this.vm.getIPAddress(), (int)22);
            System.err.printf("testing socket %s%n", socket);
            System.err.printf("testing ssh %s%n", socket);
            this.checkSSH(socket);
        } else {
            System.err.printf("skipping ssh %s, as private%n", this.vm.getIPAddress());
        }
    }

    @Test(dependsOnMethods={"testCreateVirtualMachine"})
    public void testLifeCycle() throws Exception {
        String job = this.client.getVirtualMachineClient().stopVirtualMachine(this.vm.getId());
        Assert.assertTrue((boolean)this.jobComplete.apply((Object)job));
        this.vm = this.client.getVirtualMachineClient().getVirtualMachine(this.vm.getId());
        Assert.assertEquals((Object)this.vm.getState(), (Object)VirtualMachine.State.STOPPED);
        if (this.vm.isPasswordEnabled()) {
            job = this.client.getVirtualMachineClient().resetPasswordForVirtualMachine(this.vm.getId());
            Assert.assertTrue((boolean)this.jobComplete.apply((Object)job));
            this.vm = (VirtualMachine)this.client.getAsyncJobClient().getAsyncJob(job).getResult();
            if (this.vm.getPassword() != null) {
                this.conditionallyCheckSSH();
            }
        }
        job = this.client.getVirtualMachineClient().startVirtualMachine(this.vm.getId());
        Assert.assertTrue((boolean)this.jobComplete.apply((Object)job));
        this.vm = this.client.getVirtualMachineClient().getVirtualMachine(this.vm.getId());
        Assert.assertEquals((Object)this.vm.getState(), (Object)VirtualMachine.State.RUNNING);
        job = this.client.getVirtualMachineClient().rebootVirtualMachine(this.vm.getId());
        Assert.assertTrue((boolean)this.jobComplete.apply((Object)job));
        this.vm = this.client.getVirtualMachineClient().getVirtualMachine(this.vm.getId());
        Assert.assertEquals((Object)this.vm.getState(), (Object)VirtualMachine.State.RUNNING);
    }

    @AfterGroups(groups={"live"})
    protected void tearDownContext() {
        if (this.vm != null) {
            this.destroyMachine(this.vm);
            this.vm = null;
        }
        super.tearDownContext();
    }

    @Test
    public void testListVirtualMachines() throws Exception {
        Set response = this.client.getVirtualMachineClient().listVirtualMachines(new ListVirtualMachinesOptions[0]);
        assert (null != response);
        Assert.assertTrue((response.size() >= 0 ? 1 : 0) != 0);
        for (VirtualMachine vm : response) {
            VirtualMachine newDetails = (VirtualMachine)Iterables.getOnlyElement((Iterable)this.client.getVirtualMachineClient().listVirtualMachines(new ListVirtualMachinesOptions[]{ListVirtualMachinesOptions.Builder.id((String)vm.getId())}));
            Assert.assertEquals((String)vm.getId(), (String)newDetails.getId());
            this.checkVm(vm);
        }
    }

    protected void checkVm(VirtualMachine vm) {
        Assert.assertEquals((String)vm.getId(), (String)this.client.getVirtualMachineClient().getVirtualMachine(vm.getId()).getId());
        assert (vm.getId() != null) : vm;
        assert (vm.getName() != null) : vm;
        assert (vm.getAccount() != null) : vm;
        assert (vm.getDomain() != null) : vm;
        assert (vm.getDomainId() != null) : vm;
        assert (vm.getCreated() != null) : vm;
        assert (vm.getState() != null) : vm;
        assert (vm.getZoneId() != null) : vm;
        assert (vm.getZoneName() != null) : vm;
        assert (vm.getTemplateId() != null) : vm;
        assert (vm.getTemplateName() != null) : vm;
        assert (vm.getServiceOfferingId() != null) : vm;
        assert (vm.getServiceOfferingName() != null) : vm;
        assert (vm.getCpuCount() > 0L) : vm;
        assert (vm.getCpuSpeed() > 0L) : vm;
        assert (vm.getMemory() > 0L) : vm;
        assert (vm.getGuestOSId() != null) : vm;
        assert (vm.getRootDeviceId() != null) : vm;
        if (vm.getJobId() != null) assert (vm.getJobStatus() != null) : vm;
        assert (vm.getNICs() != null && vm.getNICs().size() > 0) : vm;
        block4: for (NIC nic : vm.getNICs()) {
            assert (nic.getId() != null) : vm;
            assert (nic.getNetworkId() != null) : vm;
            assert (nic.getTrafficType() != null) : vm;
            assert (nic.getGuestIPType() != null) : vm;
            switch (vm.getState()) {
                case RUNNING: {
                    assert (nic.getNetmask() != null) : vm;
                    assert (nic.getGateway() != null) : vm;
                    assert (nic.getIPAddress() != null) : vm;
                    continue block4;
                }
                case STARTING: {
                    assert (nic.getNetmask() == null) : vm;
                    assert (nic.getGateway() == null) : vm;
                    assert (nic.getIPAddress() == null) : vm;
                    continue block4;
                }
            }
            assert (nic.getNetmask() != null) : vm;
            assert (nic.getGateway() != null) : vm;
            assert (nic.getIPAddress() != null) : vm;
        }
        assert (vm.getSecurityGroups() != null && vm.getSecurityGroups().size() >= 0) : vm;
        assert (vm.getHypervisor() != null) : vm;
    }
}

