/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.cloudstack.domain.IngressRule;
import org.jclouds.cloudstack.domain.SecurityGroup;
import org.jclouds.cloudstack.predicates.SecurityGroupPredicates;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class SecurityGroupPredicatesTest {
    public SecurityGroup group() {
        return SecurityGroup.builder().id("13").name("default").description("description").account("adrian").domainId("1").domain("ROOT").ingressRules((Set)ImmutableSet.of((Object)IngressRule.builder().id("5").protocol("tcp").startPort(22).endPort(22).securityGroupName("adriancole").account("adrian").build(), (Object)IngressRule.builder().id("6").protocol("udp").startPort(11).endPort(11).CIDR("1.1.1.1/24").build(), (Object)IngressRule.builder().id("7").protocol("tcp").startPort(40).endPort(50).CIDR("1.1.1.1/24").build(), (Object)IngressRule.builder().id("8").protocol("tcp").startPort(60).endPort(60).CIDR("2.2.2.2/16").build())).build();
    }

    @Test
    public void testPortInRange() {
        Assert.assertTrue((boolean)SecurityGroupPredicates.portInRange((int)22).apply((Object)this.group()));
        Assert.assertTrue((boolean)SecurityGroupPredicates.portInRange((int)45).apply((Object)this.group()));
        Assert.assertFalse((boolean)SecurityGroupPredicates.portInRange((int)100).apply((Object)this.group()));
    }

    @Test
    public void testHasCidr() {
        Assert.assertTrue((boolean)SecurityGroupPredicates.hasCidr((String)"1.1.1.1/24").apply((Object)this.group()));
        Assert.assertFalse((boolean)SecurityGroupPredicates.hasCidr((String)"3.3.3.3/25").apply((Object)this.group()));
    }

    @Test
    public void testPortInRangeForCidr() {
        Assert.assertTrue((boolean)SecurityGroupPredicates.portInRangeForCidr((int)11, (String)"1.1.1.1/24").apply((Object)this.group()));
        Assert.assertTrue((boolean)SecurityGroupPredicates.portInRangeForCidr((int)45, (String)"1.1.1.1/24").apply((Object)this.group()));
        Assert.assertFalse((boolean)SecurityGroupPredicates.portInRangeForCidr((int)45, (String)"2.2.2.2/16").apply((Object)this.group()));
        Assert.assertFalse((boolean)SecurityGroupPredicates.portInRangeForCidr((int)11, (String)"2.2.2.2/16").apply((Object)this.group()));
        Assert.assertFalse((boolean)SecurityGroupPredicates.portInRangeForCidr((int)11, (String)"3.3.3.3/25").apply((Object)this.group()));
    }

    @Test
    public void testNameEquals() {
        Assert.assertTrue((boolean)SecurityGroupPredicates.nameEquals((String)"default").apply((Object)this.group()));
        Assert.assertFalse((boolean)SecurityGroupPredicates.nameEquals((String)"not-default").apply((Object)this.group()));
    }
}

