/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.concurrent.TimeUnit;
import org.jclouds.cloudwatch.CloudWatch;
import org.jclouds.cloudwatch.CloudWatchApi;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.MetricDatum;
import org.jclouds.cloudwatch.domain.Unit;
import org.jclouds.cloudwatch.internal.BaseCloudWatchApiLiveTest;
import org.jclouds.cloudwatch.options.ListMetricsOptions;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CloudWatchLiveTest
extends BaseCloudWatchApiLiveTest {
    public CloudWatchLiveTest() {
        this.provider = "cloudwatch";
    }

    @Test
    protected void testCloudWatch() {
        String metricName = "TestMetricName" + System.currentTimeMillis();
        String namespace = "JCLOUDS/Test";
        Date metricTimestamp = new Date();
        LinkedHashSet metrics = Sets.newLinkedHashSet();
        for (int i = 0; i < 11; ++i) {
            metrics.add(MetricDatum.builder().metricName(metricName + "_" + i).dimension(new Dimension("BaseMetricName", metricName)).unit(Unit.COUNT).timestamp(metricTimestamp).value(Double.valueOf(i)).build());
        }
        CloudWatch.putMetricData((CloudWatchApi)((CloudWatchApi)this.api), null, (Iterable)metrics, (String)namespace);
        ListMetricsOptions lmo = ListMetricsOptions.Builder.namespace((String)namespace).dimension(new Dimension("BaseMetricName", metricName));
        boolean success = Predicates2.retry((Predicate)new Predicate<ListMetricsOptions>(){

            public boolean apply(ListMetricsOptions options) {
                return Iterables.size((Iterable)CloudWatch.listMetrics((CloudWatchApi)((CloudWatchApi)CloudWatchLiveTest.this.api), null, (ListMetricsOptions)options)) == 11;
            }
        }, (long)20L, (long)1L, (TimeUnit)TimeUnit.MINUTES).apply((Object)lmo);
        if (!success) {
            Assert.fail((String)"Unable to gather the created CloudWatch data within the time (20m) allotted.");
        }
    }
}

