/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.features;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.cloudwatch.CloudWatchApi;
import org.jclouds.cloudwatch.domain.Datapoint;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.GetMetricStatistics;
import org.jclouds.cloudwatch.domain.GetMetricStatisticsResponse;
import org.jclouds.cloudwatch.domain.Metric;
import org.jclouds.cloudwatch.domain.MetricDatum;
import org.jclouds.cloudwatch.domain.StatisticValues;
import org.jclouds.cloudwatch.domain.Statistics;
import org.jclouds.cloudwatch.domain.Unit;
import org.jclouds.cloudwatch.features.MetricApi;
import org.jclouds.cloudwatch.internal.BaseCloudWatchApiLiveTest;
import org.jclouds.cloudwatch.options.ListMetricsOptions;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="MetricApiLiveTest")
public class MetricApiLiveTest
extends BaseCloudWatchApiLiveTest {
    @Test
    protected void testPutMetricData() throws Exception {
        String metricName = "TestMetricName" + System.currentTimeMillis();
        String namespace = "JCLOUDS/Test";
        Date metricTimestamp = new Date();
        Date metricTimestampInCloudWatch = new Date(metricTimestamp.getTime() - metricTimestamp.getTime() % 60000L);
        StatisticValues ss = StatisticValues.builder().maximum(4.0).minimum(1.0).sampleCount(4.0).sum(10.0).build();
        MetricDatum metricDatum = MetricDatum.builder().metricName(metricName + "_1").statisticValues(ss).dimension(new Dimension("BaseMetricName", metricName)).dimension(new Dimension("TestDimension2", "TEST2")).unit(Unit.COUNT).timestamp(metricTimestamp).build();
        MetricDatum metricDatum2 = MetricDatum.builder().metricName(metricName + "_2").dimension(new Dimension("BaseMetricName", metricName)).unit(Unit.COUNT).timestamp(metricTimestamp).value(Double.valueOf(10.0)).build();
        this.api().putMetricsInNamespace((Iterable)ImmutableSet.of((Object)metricDatum, (Object)metricDatum2), namespace);
        ListMetricsOptions lmo = ListMetricsOptions.Builder.namespace((String)namespace).dimension(new Dimension("BaseMetricName", metricName));
        boolean success = Predicates2.retry((Predicate)new Predicate<ListMetricsOptions>(){

            public boolean apply(ListMetricsOptions options) {
                return Iterables.size((Iterable)MetricApiLiveTest.this.api().list(options)) == 2;
            }
        }, (long)20L, (long)1L, (TimeUnit)TimeUnit.MINUTES).apply((Object)lmo);
        if (!success) {
            Assert.fail((String)"Unable to gather the created CloudWatch data within the time (20m) allotted.");
        }
        IterableWithMarker lmr = this.api().list(lmo);
        Date endTime = new Date(metricTimestampInCloudWatch.getTime() + 60000L);
        Date startTime = new Date(metricTimestampInCloudWatch.getTime() - 60000L);
        for (Metric m : lmr) {
            GetMetricStatistics gms = GetMetricStatistics.builder().dimensions(m.getDimensions()).namespace(namespace).metricName(m.getMetricName()).endTime(endTime).statistic(Statistics.MAXIMUM).statistic(Statistics.MINIMUM).statistic(Statistics.SAMPLE_COUNT).statistic(Statistics.SUM).period(60).startTime(startTime).unit(Unit.COUNT).build();
            GetMetricStatisticsResponse gmr = this.api().getMetricStatistics(gms);
            Assert.assertEquals((int)1, (int)Iterables.size((Iterable)gmr));
            Datapoint datapoint = (Datapoint)gmr.iterator().next();
            Assert.assertEquals((Object)datapoint.getTimestamp(), (Object)metricTimestampInCloudWatch);
            Assert.assertNull((Object)datapoint.getCustomUnit());
            Assert.assertEquals((Object)Unit.COUNT, (Object)datapoint.getUnit());
            Assert.assertNull((Object)datapoint.getAverage());
            if (m.getDimensions().size() == 1) {
                Assert.assertEquals((Object)10.0, (Object)datapoint.getMaximum());
                Assert.assertEquals((Object)10.0, (Object)datapoint.getMinimum());
                Assert.assertEquals((Object)10.0, (Object)datapoint.getSum());
                Assert.assertEquals((Object)1.0, (Object)datapoint.getSamples());
                continue;
            }
            Assert.assertEquals((Object)4.0, (Object)datapoint.getMaximum());
            Assert.assertEquals((Object)1.0, (Object)datapoint.getMinimum());
            Assert.assertEquals((Object)10.0, (Object)datapoint.getSum());
            Assert.assertEquals((Object)4.0, (Object)datapoint.getSamples());
        }
    }

    @Test
    protected void testGetMetricStatistics() {
        IterableWithMarker metricsResponse = this.api().list(new ListMetricsOptions());
        if (Iterables.size((Iterable)metricsResponse) > 0) {
            for (Metric metric : metricsResponse) {
                Set dimensions = metric.getDimensions();
                boolean testRan = false;
                for (Dimension dimension : dimensions) {
                    Date endTime = new Date();
                    Calendar cal = Calendar.getInstance();
                    cal.add(12, -1440);
                    GetMetricStatistics options = GetMetricStatistics.builder().dimension(dimension).endTime(endTime).metricName(metric.getMetricName()).namespace(metric.getNamespace()).period(300).startTime(cal.getTime()).statistics((Set)ImmutableSet.of((Object)Statistics.MAXIMUM, (Object)Statistics.MINIMUM)).unit(Unit.PERCENT).build();
                    GetMetricStatisticsResponse response = this.api().getMetricStatistics(options);
                    if (response.size() <= 0) continue;
                    Preconditions.checkNotNull((Object)response.getLabel());
                    for (Datapoint datapoint : response) {
                        Preconditions.checkArgument((datapoint.getAverage() == null ? 1 : 0) != 0);
                        Preconditions.checkNotNull((Object)datapoint.getMaximum());
                        Preconditions.checkNotNull((Object)datapoint.getMinimum());
                    }
                    testRan = true;
                    break;
                }
                if (!testRan) continue;
                break;
            }
        }
    }

    @Test
    protected void testListMetrics() {
        Set dimensions;
        String testNamespace = "AWS/EC2";
        String testMetricName = "CPUUtilization";
        String testDimensionName = "InstanceType";
        String testDimensionValue = "t1.micro";
        IterableWithMarker response = this.api().list(new ListMetricsOptions());
        this.performDefaultMetricsTests((IterableWithMarker<Metric>)response);
        if (Iterables.size((Iterable)response) > 0) {
            Metric metric = (Metric)response.iterator().next();
            testMetricName = metric.getMetricName();
            testNamespace = metric.getNamespace();
            if (metric.getDimensions().size() > 0) {
                Dimension dimension = (Dimension)metric.getDimensions().iterator().next();
                testDimensionName = dimension.getName();
                testDimensionValue = dimension.getValue();
            }
            if (testDimensionName == null) {
                for (Metric metric1 : response) {
                    dimensions = metric1.getDimensions();
                    if (dimensions.size() <= 0) continue;
                    Dimension dimension = (Dimension)metric.getDimensions().iterator().next();
                    testDimensionName = dimension.getName();
                    testDimensionValue = dimension.getValue();
                    break;
                }
            }
        }
        response = this.api().list(ListMetricsOptions.Builder.afterMarker((Object)response.nextMarker().orNull()));
        this.performDefaultMetricsTests((IterableWithMarker<Metric>)response);
        response = this.api().list(ListMetricsOptions.Builder.namespace((String)testNamespace));
        this.performDefaultMetricsTests((IterableWithMarker<Metric>)response);
        for (Metric metric : response) {
            Preconditions.checkArgument((boolean)metric.getNamespace().equals(testNamespace), (Object)("All metrics should have the " + testNamespace + " Namespace."));
        }
        response = this.api().list(ListMetricsOptions.Builder.metricName((String)testMetricName));
        this.performDefaultMetricsTests((IterableWithMarker<Metric>)response);
        for (Metric metric : response) {
            Preconditions.checkArgument((boolean)metric.getMetricName().equals(testMetricName), (Object)("All metrics should have the " + testMetricName + " MetricName."));
        }
        if (testDimensionName != null) {
            Dimension testDimension = new Dimension(testDimensionName, testDimensionValue);
            response = this.api().list(ListMetricsOptions.Builder.dimension((Dimension)testDimension));
            this.performDefaultMetricsTests((IterableWithMarker<Metric>)response);
            for (Metric metric : response) {
                dimensions = metric.getDimensions();
                boolean dimensionFound = false;
                for (Dimension dimension : dimensions) {
                    if (!dimension.getName().equals(testDimensionName)) continue;
                    dimensionFound = true;
                    break;
                }
                Preconditions.checkArgument((boolean)dimensionFound, (Object)("All metrics should have the " + testDimensionName + " Dimension.Name."));
            }
        }
    }

    private void performDefaultMetricsTests(IterableWithMarker<Metric> response) {
        if (Iterables.size(response) < 500) {
            Preconditions.checkArgument((!response.nextMarker().isPresent() ? 1 : 0) != 0, (Object)"NextToken should be null for response with fewer than 500 metrics.");
        }
        for (Metric metric : response) {
            Set dimensions = metric.getDimensions();
            Preconditions.checkArgument((dimensions.size() <= 10 ? 1 : 0) != 0, (Object)"Dimensions set cannot be greater than 10 items.");
            for (Dimension dimension : dimensions) {
                Preconditions.checkNotNull((Object)dimension.getName(), (Object)"Name cannot be null for a Dimension.");
                Preconditions.checkNotNull((Object)dimension.getValue(), (Object)"Value cannot be null for a Dimension.");
            }
            Preconditions.checkNotNull((Object)metric.getMetricName(), (Object)"MetricName cannot be null for a Metric.");
            Preconditions.checkNotNull((Object)metric.getNamespace(), (Object)"Namespace cannot be null for a Metric.");
        }
    }

    protected MetricApi api() {
        return ((CloudWatchApi)this.api).getMetricApiForRegion(null);
    }
}

