/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.xml;

import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.Set;
import org.jclouds.cloudwatch.domain.Datapoint;
import org.jclouds.cloudwatch.domain.Unit;
import org.jclouds.cloudwatch.xml.GetMetricStatisticsResponseHandler;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GetMetricStatisticsResponseHandlerTest")
public class GetMetricStatisticsResponseHandlerTest
extends BaseHandlerTest {
    DateService dateService = new SimpleDateFormatDateService();

    public void testApplyInputStream() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/get_metric_statistics.xml");
        Set<Datapoint> expected = this.expected();
        GetMetricStatisticsResponseHandler handler = (GetMetricStatisticsResponseHandler)this.injector.getInstance(GetMetricStatisticsResponseHandler.class);
        Set result = (Set)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((Set)result, expected);
    }

    public Set<Datapoint> expected() {
        ImmutableSet expected = ImmutableSet.of((Object)new Datapoint(Double.valueOf(0.17777777777777778), null, null, this.dateService.iso8601SecondsDateParse("2009-01-16T00:00:00Z"), Double.valueOf(9.0), null, Unit.PERCENT, null), (Object)new Datapoint(Double.valueOf(0.1), null, null, this.dateService.iso8601SecondsDateParse("2009-01-16T00:01:00Z"), Double.valueOf(8.0), null, Unit.PERCENT, null));
        return expected;
    }
}

