/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.xml;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import org.jclouds.cloudwatch.domain.AlarmHistoryItem;
import org.jclouds.cloudwatch.domain.HistoryItemType;
import org.jclouds.cloudwatch.xml.ListAlarmHistoryResponseHandler;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.IterableWithMarkers;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ListAlarmHistoryResponseHandlerTest")
public class ListAlarmHistoryResponseHandlerTest
extends BaseHandlerTest {
    public void testParseFullResponse() throws Exception {
        IterableWithMarker alarmHistoryItems = (IterableWithMarker)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(ListAlarmHistoryResponseHandler.class)).parse(((Object)((Object)this)).getClass().getResourceAsStream("/DescribeAlarmHistoryResponse.xml"));
        Assert.assertEquals((String)alarmHistoryItems.toString(), (String)this.expected().toString());
        Assert.assertFalse((boolean)alarmHistoryItems.nextMarker().isPresent());
    }

    public IterableWithMarker<AlarmHistoryItem> expected() {
        LinkedHashSet alarmHistoryItems = Sets.newLinkedHashSet();
        for (int i = 1; i <= 2; ++i) {
            alarmHistoryItems.add(new AlarmHistoryItem("TestAlarmName" + i, "{\"reason\": \"" + i + "\"}", i == 1 ? HistoryItemType.ACTION : HistoryItemType.CONFIGURATION_UPDATE, "This is test " + i + ".", new SimpleDateFormatDateService().iso8601SecondsDateParse("2013-01-0" + i + "T00:00:00Z")));
        }
        return IterableWithMarkers.from((Iterable)alarmHistoryItems);
    }
}

