/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.features;

import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Named;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.Fallbacks;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.cloudwatch.binders.GetMetricStatisticsBinder;
import org.jclouds.cloudwatch.binders.MetricDataBinder;
import org.jclouds.cloudwatch.domain.GetMetricStatistics;
import org.jclouds.cloudwatch.domain.GetMetricStatisticsResponse;
import org.jclouds.cloudwatch.domain.Metric;
import org.jclouds.cloudwatch.domain.MetricDatum;
import org.jclouds.cloudwatch.functions.MetricsToPagedIterable;
import org.jclouds.cloudwatch.options.GetMetricStatisticsOptions;
import org.jclouds.cloudwatch.options.ListMetricsOptions;
import org.jclouds.cloudwatch.xml.GetMetricStatisticsResponseHandlerV2;
import org.jclouds.cloudwatch.xml.ListMetricsResponseHandler;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={FormSigner.class})
@VirtualHost
public interface MetricAsyncApi {
    @Named(value="ListMetrics")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=ListMetricsResponseHandler.class)
    @Transform(value=MetricsToPagedIterable.class)
    @FormParams(keys={"Action"}, values={"ListMetrics"})
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends PagedIterable<Metric>> list();

    @Named(value="ListMetrics")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=ListMetricsResponseHandler.class)
    @FormParams(keys={"Action"}, values={"ListMetrics"})
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListenableFuture<? extends IterableWithMarker<Metric>> list(ListMetricsOptions var1);

    @Named(value="GetMetricStatistics")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=GetMetricStatisticsResponseHandlerV2.class)
    @FormParams(keys={"Action"}, values={"GetMetricStatistics"})
    public ListenableFuture<? extends GetMetricStatisticsResponse> getMetricStatistics(@BinderParam(value=GetMetricStatisticsBinder.class) GetMetricStatistics var1);

    @Named(value="GetMetricStatistics")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=GetMetricStatisticsResponseHandlerV2.class)
    @FormParams(keys={"Action"}, values={"GetMetricStatistics"})
    public ListenableFuture<? extends GetMetricStatisticsResponse> getMetricStatistics(@BinderParam(value=GetMetricStatisticsBinder.class) GetMetricStatistics var1, GetMetricStatisticsOptions var2);

    @Named(value="PutMetricData")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"PutMetricData"})
    public ListenableFuture<Void> putMetricsInNamespace(@BinderParam(value=MetricDataBinder.class) Iterable<MetricDatum> var1, @FormParam(value="Namespace") String var2);
}

