/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.net.HostAndPort;
import com.google.inject.Injector;
import java.net.UnknownHostException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.ec2.domain.Image;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.IpProtocol;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.domain.Snapshot;
import org.jclouds.ec2.domain.Volume;
import org.jclouds.ec2.options.CreateSnapshotOptions;
import org.jclouds.ec2.options.DescribeImagesOptions;
import org.jclouds.ec2.options.DetachVolumeOptions;
import org.jclouds.ec2.options.RegisterImageBackedByEbsOptions;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.jclouds.ec2.predicates.InstanceStateRunning;
import org.jclouds.ec2.predicates.InstanceStateStopped;
import org.jclouds.ec2.predicates.InstanceStateTerminated;
import org.jclouds.ec2.predicates.SnapshotCompleted;
import org.jclouds.ec2.predicates.VolumeAttached;
import org.jclouds.ec2.predicates.VolumeAvailable;
import org.jclouds.http.HttpResponseException;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.predicates.SocketOpen;
import org.jclouds.scriptbuilder.InitScript;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.ssh.SshClient;
import org.jclouds.ssh.SshException;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"live"}, enabled=false, singleThreaded=true, testName="EBSBootEC2ClientLiveTest")
public class EBSBootEC2ClientLiveTest
extends BaseComputeServiceContextLiveTest {
    private static final String IMAGE_ID = "ami-7e28ca17";
    private static final int VOLUME_SIZE = 2;
    private static final String SCRIPT_END = "----COMPLETE----";
    private static final String INSTANCE_PREFIX = System.getProperty("user.name") + ".ec2ebs";
    private EC2Client client;
    private SshClient.Factory sshFactory;
    private KeyPair keyPair;
    private String securityGroupName;
    private Predicate<HostAndPort> socketTester;
    private Predicate<Attachment> attachTester;
    private Predicate<Volume> volumeTester;
    private RunningInstance instance;
    private Predicate<RunningInstance> runningTester;
    private Predicate<RunningInstance> stoppedTester;
    private Predicate<RunningInstance> terminatedTester;
    private Volume volume;
    private Predicate<Snapshot> snapshotTester;
    private Snapshot snapshot;
    private Image ebsImage;
    private RunningInstance ebsInstance;
    private Attachment attachment;
    private String mkEbsBoot;

    public EBSBootEC2ClientLiveTest() {
        this.provider = "ec2";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        Injector injector = ((ComputeServiceContext)this.view).utils().injector();
        this.client = (EC2Client)injector.getInstance(EC2Client.class);
        this.sshFactory = (SshClient.Factory)injector.getInstance(SshClient.Factory.class);
        SocketOpen socketOpen = (SocketOpen)injector.getInstance(SocketOpen.class);
        this.socketTester = Predicates2.retry((Predicate)socketOpen, (long)120L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        VolumeAvailable volumeAvailable = (VolumeAvailable)injector.getInstance(VolumeAvailable.class);
        this.volumeTester = Predicates2.retry((Predicate)volumeAvailable, (long)60L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        SnapshotCompleted snapshotCompleted = (SnapshotCompleted)injector.getInstance(SnapshotCompleted.class);
        this.snapshotTester = Predicates2.retry((Predicate)snapshotCompleted, (long)120L, (long)3L, (TimeUnit)TimeUnit.SECONDS);
        VolumeAttached volumeAttached = (VolumeAttached)injector.getInstance(VolumeAttached.class);
        this.attachTester = Predicates2.retry((Predicate)volumeAttached, (long)60L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.runningTester = Predicates2.retry((Predicate)new InstanceStateRunning(this.client), (long)180L, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        InstanceStateStopped instanceStateStopped = (InstanceStateStopped)injector.getInstance(InstanceStateStopped.class);
        this.stoppedTester = Predicates2.retry((Predicate)instanceStateStopped, (long)60L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        InstanceStateTerminated instanceStateTerminated = (InstanceStateTerminated)injector.getInstance(InstanceStateTerminated.class);
        this.terminatedTester = Predicates2.retry((Predicate)instanceStateTerminated, (long)60L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        injector.injectMembers((Object)socketOpen);
    }

    @Test(enabled=false)
    void testCreateSecurityGroupIngressCidr() throws InterruptedException, ExecutionException, TimeoutException {
        this.securityGroupName = INSTANCE_PREFIX + "ingress";
        try {
            this.client.getSecurityGroupServices().deleteSecurityGroupInRegion(null, this.securityGroupName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.client.getSecurityGroupServices().createSecurityGroupInRegion(null, this.securityGroupName, this.securityGroupName);
        this.client.getSecurityGroupServices().authorizeSecurityGroupIngressInRegion(null, this.securityGroupName, IpProtocol.TCP, 80, 80, "0.0.0.0/0");
        this.client.getSecurityGroupServices().authorizeSecurityGroupIngressInRegion(null, this.securityGroupName, IpProtocol.TCP, 443, 443, "0.0.0.0/0");
        this.client.getSecurityGroupServices().authorizeSecurityGroupIngressInRegion(null, this.securityGroupName, IpProtocol.TCP, 22, 22, "0.0.0.0/0");
    }

    @Test(enabled=false)
    void testCreateKeyPair() {
        String keyName = INSTANCE_PREFIX + "1";
        try {
            this.client.getKeyPairServices().deleteKeyPairInRegion(null, keyName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.keyPair = this.client.getKeyPairServices().createKeyPairInRegion(null, keyName);
        Assert.assertNotNull((Object)this.keyPair);
        Assert.assertNotNull((Object)this.keyPair.getKeyMaterial());
        Assert.assertNotNull((Object)this.keyPair.getSha1OfPrivateKey());
        Assert.assertEquals((String)this.keyPair.getKeyName(), (String)keyName);
    }

    @Test(enabled=false, dependsOnMethods={"testCreateKeyPair", "testCreateSecurityGroupIngressCidr"})
    public void testCreateRunningInstance() throws Exception {
        this.instance = this.createInstance(IMAGE_ID);
    }

    private RunningInstance createInstance(String imageId) throws UnknownHostException {
        RunningInstance instance = null;
        while (instance == null) {
            try {
                System.out.printf("%d: running instance%n", System.currentTimeMillis());
                Reservation reservation = this.client.getInstanceServices().runInstancesInRegion(null, null, imageId, 1, 1, new RunInstancesOptions[]{RunInstancesOptions.Builder.withKeyName((String)this.keyPair.getKeyName()).asType("m1.small").withSecurityGroup(this.securityGroupName)});
                instance = (RunningInstance)Iterables.getOnlyElement((Iterable)reservation);
            }
            catch (HttpResponseException htpe) {
                if (htpe.getResponse().getStatusCode() == 400) continue;
                throw htpe;
            }
        }
        Assert.assertNotNull((Object)instance.getId());
        Assert.assertEquals((Object)instance.getInstanceState(), (Object)InstanceState.PENDING);
        instance = this.blockUntilWeCanSshIntoInstance(instance);
        return instance;
    }

    @Test(enabled=false, dependsOnMethods={"testCreateRunningInstance"})
    void testCreateAndAttachVolume() {
        this.volume = this.client.getElasticBlockStoreServices().createVolumeInAvailabilityZone(this.instance.getAvailabilityZone(), 2);
        System.out.printf("%d: %s awaiting volume to become available%n", System.currentTimeMillis(), this.volume.getId());
        assert (this.volumeTester.apply((Object)this.volume));
        Attachment attachment = this.client.getElasticBlockStoreServices().attachVolumeInRegion(this.instance.getRegion(), this.volume.getId(), this.instance.getId(), "/dev/sdh");
        System.out.printf("%d: %s awaiting attachment to complete%n", System.currentTimeMillis(), attachment.getId());
        assert (this.attachTester.apply((Object)attachment));
        System.out.printf("%d: %s attachment complete%n", System.currentTimeMillis(), attachment.getId());
    }

    @BeforeTest
    void makeScript() {
        this.mkEbsBoot = InitScript.builder().name("mkebsboot").home("/tmp").logDir("/tmp/logs").exportVariables((Map)ImmutableMap.of((Object)"imageDir", (Object)"/mnt/tmp", (Object)"ebsDevice", (Object)"/dev/sdh", (Object)"ebsMountPoint", (Object)"/mnt/ebs")).run(Statements.interpret((String[])new String[]{"echo creating a filesystem and mounting the ebs volume", "{md} {varl}IMAGE_DIR{varr} {varl}EBS_MOUNT_POINT{varr}", "rm -rf {varl}IMAGE_DIR{varr}/*", "yes| mkfs -t ext3 {varl}EBS_DEVICE{varr} 2>&-", "mount {varl}EBS_DEVICE{varr} {varl}EBS_MOUNT_POINT{varr}", "echo making a local working copy of the boot disk", "rsync -ax --exclude /ubuntu/.bash_history --exclude /home/*/.bash_history --exclude /etc/ssh/ssh_host_* --exclude /etc/ssh/moduli --exclude /etc/udev/rules.d/*persistent-net.rules --exclude /var/lib/* --exclude=/mnt/* --exclude=/proc/* --exclude=/tmp/* --exclude=/dev/log / {varl}IMAGE_DIR{varr}", "echo preparing the local working copy", "touch {varl}IMAGE_DIR{varr}/etc/init.d/ec2-init-user-data", "echo copying the local working copy to the ebs mount", "{cd} {varl}IMAGE_DIR{varr}", "tar -cSf - * | tar xf - -C {varl}EBS_MOUNT_POINT{varr}", "echo size of ebs", "du -sk {varl}EBS_MOUNT_POINT{varr}", "echo size of source", "du -sk {varl}IMAGE_DIR{varr}", "rm -rf {varl}IMAGE_DIR{varr}/*", "umount {varl}EBS_MOUNT_POINT{varr}", "echo ----COMPLETE----"})).build().render(OsFamily.UNIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=false, dependsOnMethods={"testCreateAndAttachVolume"})
    void testBundleInstance() {
        SshClient ssh = this.sshFactory.create(HostAndPort.fromParts((String)this.instance.getIpAddress(), (int)22), LoginCredentials.builder().user("ubuntu").privateKey(this.keyPair.getKeyMaterial()).build());
        try {
            ssh.connect();
        }
        catch (SshException e) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            ssh.connect();
        }
        try {
            System.out.printf("%d: %s writing ebs script%n", System.currentTimeMillis(), this.instance.getId());
            String script = "/tmp/mkebsboot-init.sh";
            ssh.put(script, (Payload)Payloads.newStringPayload((String)this.mkEbsBoot));
            System.out.printf("%d: %s launching ebs script%n", System.currentTimeMillis(), this.instance.getId());
            ssh.exec("chmod 755 " + script);
            ssh.exec(script + " init");
            ExecResponse output = ssh.exec("sudo " + script + " start");
            System.out.println(output);
            output = ssh.exec(script + " status");
            assert (!output.getOutput().trim().equals("")) : output;
            Predicate scriptTester = Predicates2.retry((Predicate)new ScriptTester(ssh, SCRIPT_END), (long)600L, (long)10L, (TimeUnit)TimeUnit.SECONDS);
            scriptTester.apply((Object)script);
        }
        finally {
            if (ssh != null) {
                ssh.disconnect();
            }
        }
    }

    @Test(enabled=false, dependsOnMethods={"testBundleInstance"})
    void testAMIFromBundle() {
        this.volume = (Volume)Iterables.getOnlyElement((Iterable)this.client.getElasticBlockStoreServices().describeVolumesInRegion(this.volume.getRegion(), new String[]{this.volume.getId()}));
        if (this.volume.getAttachments().size() > 0) {
            this.client.getElasticBlockStoreServices().detachVolumeInRegion(this.instance.getRegion(), this.volume.getId(), false, new DetachVolumeOptions[0]);
            System.out.printf("%d: %s awaiting detachment to complete%n", System.currentTimeMillis(), this.volume.getId());
            assert (this.volumeTester.apply((Object)this.volume));
        } else {
            this.attachment = null;
        }
        this.snapshot = this.client.getElasticBlockStoreServices().createSnapshotInRegion(this.volume.getRegion(), this.volume.getId(), new CreateSnapshotOptions[]{CreateSnapshotOptions.Builder.withDescription((String)"EBS Ubuntu Hardy")});
        System.out.printf("%d: %s awaiting snapshot to complete%n", System.currentTimeMillis(), this.snapshot.getId());
        assert (this.snapshotTester.apply((Object)this.snapshot));
        Image image = (Image)Iterables.getOnlyElement((Iterable)this.client.getAMIServices().describeImagesInRegion(this.snapshot.getRegion(), new DescribeImagesOptions[]{DescribeImagesOptions.Builder.imageIds((String[])new String[]{IMAGE_ID})}));
        String description = image.getDescription() == null ? "jclouds" : image.getDescription();
        System.out.printf("%d: %s creating ami from snapshot%n", System.currentTimeMillis(), this.snapshot.getId());
        String amiId = this.client.getAMIServices().registerUnixImageBackedByEbsInRegion(this.snapshot.getRegion(), "ebsboot-" + image.getId(), this.snapshot.getId(), new RegisterImageBackedByEbsOptions[]{RegisterImageBackedByEbsOptions.Builder.withKernelId((String)image.getKernelId()).withRamdisk(image.getRamdiskId()).withDescription(description).asArchitecture(Image.Architecture.I386)});
        try {
            this.ebsImage = (Image)Iterables.getOnlyElement((Iterable)this.client.getAMIServices().describeImagesInRegion(this.snapshot.getRegion(), new DescribeImagesOptions[]{DescribeImagesOptions.Builder.imageIds((String[])new String[]{amiId})}));
        }
        catch (AWSResponseException e) {
            if (e.getError().getClass().equals("InvalidAMIID.NotFound")) {
                this.ebsImage = (Image)Iterables.getOnlyElement((Iterable)this.client.getAMIServices().describeImagesInRegion(this.snapshot.getRegion(), new DescribeImagesOptions[]{DescribeImagesOptions.Builder.imageIds((String[])new String[]{amiId})}));
            }
            throw e;
        }
        this.verifyImage();
    }

    @Test(enabled=false, dependsOnMethods={"testAMIFromBundle"})
    public void testInstanceFromEBS() throws Exception {
        System.out.printf("%d: %s creating instance from ebs-backed ami%n", System.currentTimeMillis(), this.ebsImage.getId());
        this.ebsInstance = this.createInstance(this.ebsImage.getId());
        this.client.getInstanceServices().stopInstancesInRegion(this.ebsInstance.getRegion(), true, new String[]{this.ebsInstance.getId()});
        System.out.printf("%d: %s awaiting instance to stop %n", System.currentTimeMillis(), this.ebsInstance.getId());
        this.stoppedTester.apply((Object)this.ebsInstance);
        this.tryToChangeStuff();
        System.out.printf("%d: %s awaiting instance to start %n", System.currentTimeMillis(), this.ebsInstance.getId());
        this.client.getInstanceServices().startInstancesInRegion(this.ebsInstance.getRegion(), new String[]{this.ebsInstance.getId()});
        this.ebsInstance = this.blockUntilWeCanSshIntoInstance(this.ebsInstance);
    }

    private void verifyImage() {
        Assert.assertEquals((Object)this.ebsImage.getImageType(), (Object)Image.ImageType.MACHINE);
        Assert.assertEquals((Object)this.ebsImage.getRootDeviceType(), (Object)RootDeviceType.EBS);
        Assert.assertEquals((String)this.ebsImage.getRootDeviceName(), (String)"/dev/sda1");
        Assert.assertEquals(this.ebsImage.getEbsBlockDevices().entrySet(), (Set)ImmutableMap.of((Object)"/dev/sda1", (Object)new Image.EbsBlockDevice(this.snapshot.getId(), 2L, true)).entrySet());
    }

    private void tryToChangeStuff() {
        this.setUserDataForInstanceInRegion();
        this.setRamdiskForInstanceInRegion();
        this.setKernelForInstanceInRegion();
        this.setInstanceTypeForInstanceInRegion();
        this.setInstanceInitiatedShutdownBehaviorForInstanceInRegion();
        this.setBlockDeviceMappingForInstanceInRegion();
    }

    private void setUserDataForInstanceInRegion() {
        this.client.getInstanceServices().setUserDataForInstanceInRegion(null, this.ebsInstance.getId(), "test".getBytes());
        Assert.assertEquals((String)"test", (String)this.client.getInstanceServices().getUserDataForInstanceInRegion(null, this.ebsInstance.getId()));
    }

    private void setRamdiskForInstanceInRegion() {
        String ramdisk = this.client.getInstanceServices().getRamdiskForInstanceInRegion(null, this.ebsInstance.getId());
        this.client.getInstanceServices().setRamdiskForInstanceInRegion(null, this.ebsInstance.getId(), ramdisk);
        Assert.assertEquals((String)ramdisk, (String)this.client.getInstanceServices().getRamdiskForInstanceInRegion(null, this.ebsInstance.getId()));
    }

    private void setKernelForInstanceInRegion() {
        String oldKernel = this.client.getInstanceServices().getKernelForInstanceInRegion(null, this.ebsInstance.getId());
        this.client.getInstanceServices().setKernelForInstanceInRegion(null, this.ebsInstance.getId(), oldKernel);
        Assert.assertEquals((String)oldKernel, (String)this.client.getInstanceServices().getKernelForInstanceInRegion(null, this.ebsInstance.getId()));
    }

    private void setInstanceTypeForInstanceInRegion() {
        this.client.getInstanceServices().setInstanceTypeForInstanceInRegion(null, this.ebsInstance.getId(), "c1.medium");
        Assert.assertEquals((String)"c1.medium", (String)this.client.getInstanceServices().getInstanceTypeForInstanceInRegion(null, this.ebsInstance.getId()));
        this.client.getInstanceServices().setInstanceTypeForInstanceInRegion(null, this.ebsInstance.getId(), "m1.small");
        Assert.assertEquals((String)"m1.small", (String)this.client.getInstanceServices().getInstanceTypeForInstanceInRegion(null, this.ebsInstance.getId()));
    }

    private void setBlockDeviceMappingForInstanceInRegion() {
        String volumeId = ((BlockDevice)this.ebsInstance.getEbsBlockDevices().get("/dev/sda1")).getVolumeId();
        LinkedHashMap mapping = Maps.newLinkedHashMap();
        mapping.put("/dev/sda1", new BlockDevice(volumeId, false));
        try {
            this.client.getInstanceServices().setBlockDeviceMappingForInstanceInRegion(null, this.ebsInstance.getId(), (Map)mapping);
            Map devices = this.client.getInstanceServices().getBlockDeviceMappingForInstanceInRegion(null, this.ebsInstance.getId());
            Assert.assertEquals((int)devices.size(), (int)1);
            String deviceName = (String)Iterables.getOnlyElement(devices.keySet());
            BlockDevice device = (BlockDevice)Iterables.getOnlyElement(devices.values());
            Assert.assertEquals((String)device.getVolumeId(), (String)volumeId);
            Assert.assertEquals((String)deviceName, (String)"/dev/sda1");
            Assert.assertEquals((boolean)device.isDeleteOnTermination(), (boolean)false);
            System.out.println("OK: setBlockDeviceMappingForInstanceInRegion");
        }
        catch (Exception e) {
            System.err.println("setBlockDeviceMappingForInstanceInRegion");
            e.printStackTrace();
        }
    }

    private void setInstanceInitiatedShutdownBehaviorForInstanceInRegion() {
        try {
            this.client.getInstanceServices().setInstanceInitiatedShutdownBehaviorForInstanceInRegion(null, this.ebsInstance.getId(), Volume.InstanceInitiatedShutdownBehavior.STOP);
            Assert.assertEquals((Object)Volume.InstanceInitiatedShutdownBehavior.STOP, (Object)this.client.getInstanceServices().getInstanceInitiatedShutdownBehaviorForInstanceInRegion(null, this.ebsInstance.getId()));
            this.client.getInstanceServices().setInstanceInitiatedShutdownBehaviorForInstanceInRegion(null, this.ebsInstance.getId(), Volume.InstanceInitiatedShutdownBehavior.TERMINATE);
            Assert.assertEquals((Object)Volume.InstanceInitiatedShutdownBehavior.TERMINATE, (Object)this.client.getInstanceServices().getInstanceInitiatedShutdownBehaviorForInstanceInRegion(null, this.ebsInstance.getId()));
            System.out.println("OK: setInstanceInitiatedShutdownBehaviorForInstanceInRegion");
        }
        catch (Exception e) {
            System.err.println("setInstanceInitiatedShutdownBehaviorForInstanceInRegion");
            e.printStackTrace();
        }
    }

    private void sshPing(RunningInstance newDetails) throws UnknownHostException {
        try {
            this.doCheckKey(newDetails);
        }
        catch (SshException e) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.doCheckKey(newDetails);
        }
    }

    private void doCheckKey(RunningInstance newDetails) throws UnknownHostException {
        this.doCheckKey(newDetails.getIpAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheckKey(String address) {
        SshClient ssh = this.sshFactory.create(HostAndPort.fromParts((String)address, (int)22), LoginCredentials.builder().user("ubuntu").privateKey(this.keyPair.getKeyMaterial()).build());
        try {
            ssh.connect();
            ExecResponse hello = ssh.exec("echo hello");
            Assert.assertEquals((String)hello.getOutput().trim(), (String)"hello");
        }
        finally {
            if (ssh != null) {
                ssh.disconnect();
            }
        }
    }

    private RunningInstance blockUntilWeCanSshIntoInstance(RunningInstance instance) throws UnknownHostException {
        System.out.printf("%d: %s awaiting instance to run %n", System.currentTimeMillis(), instance.getId());
        assert (this.runningTester.apply((Object)instance));
        Set reservations = this.client.getInstanceServices().describeInstancesInRegion(instance.getRegion(), new String[]{instance.getId()});
        instance = (RunningInstance)Iterables.getOnlyElement((Iterable)((Iterable)Iterables.getOnlyElement((Iterable)reservations)));
        System.out.printf("%d: %s awaiting ssh service to start%n", System.currentTimeMillis(), instance.getIpAddress());
        assert (this.socketTester.apply((Object)HostAndPort.fromParts((String)instance.getIpAddress(), (int)22)));
        System.out.printf("%d: %s ssh service started%n", System.currentTimeMillis(), instance.getDnsName());
        this.sshPing(instance);
        System.out.printf("%d: %s ssh connection made%n", System.currentTimeMillis(), instance.getId());
        return instance;
    }

    @AfterTest
    void cleanup() {
        if (this.ebsInstance != null) {
            try {
                this.client.getInstanceServices().terminateInstancesInRegion(this.ebsInstance.getRegion(), new String[]{this.ebsInstance.getId()});
                this.terminatedTester.apply((Object)this.ebsInstance);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.ebsImage != null) {
            try {
                this.client.getAMIServices().deregisterImageInRegion(this.ebsImage.getRegion(), this.ebsImage.getId());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.snapshot != null) {
            try {
                this.client.getElasticBlockStoreServices().deleteSnapshotInRegion(this.snapshot.getRegion(), this.snapshot.getId());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.attachment != null) {
            try {
                this.client.getElasticBlockStoreServices().detachVolumeInRegion(this.volume.getRegion(), this.volume.getId(), true, new DetachVolumeOptions[0]);
                assert (this.volumeTester.apply((Object)this.volume));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.instance != null) {
            try {
                this.client.getInstanceServices().terminateInstancesInRegion(this.instance.getRegion(), new String[]{this.instance.getId()});
                this.terminatedTester.apply((Object)this.instance);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.volume != null) {
            try {
                this.client.getElasticBlockStoreServices().deleteVolumeInRegion(this.volume.getRegion(), this.volume.getId());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.keyPair != null) {
            try {
                this.client.getKeyPairServices().deleteKeyPairInRegion(this.keyPair.getRegion(), this.keyPair.getKeyName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.securityGroupName != null) {
            try {
                this.client.getSecurityGroupServices().deleteSecurityGroupInRegion(null, this.securityGroupName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class ScriptTester
    implements Predicate<String> {
        private final SshClient ssh;
        private final String endMatches;

        public ScriptTester(SshClient ssh, String endMatches) {
            this.ssh = ssh;
            this.endMatches = endMatches;
        }

        public boolean apply(String script) {
            System.out.printf("%d: %s testing status%n", System.currentTimeMillis(), script);
            ExecResponse output = this.ssh.exec(script + " status");
            if (output.getOutput().trim().equals("")) {
                output = this.ssh.exec(script + " tail");
                String stdout = output.getOutput().trim();
                if (stdout.contains(this.endMatches)) {
                    return true;
                }
                output = this.ssh.exec(script + " tailerr");
                String stderr = output.getOutput().trim();
                throw new RuntimeException(String.format("script %s ended without token: stdout.log: [%s]; stderr.log: [%s]; ", script, stdout, stderr));
            }
            return false;
        }
    }
}

