/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.binders;

import com.google.common.collect.ImmutableList;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import org.jclouds.ec2.binders.BindResourceIdsToIndexedFormParams;
import org.jclouds.http.HttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindResourceIdsToIndexedFormParamsTest {
    Injector injector = Guice.createInjector((Module[])new Module[0]);
    BindResourceIdsToIndexedFormParams binder = (BindResourceIdsToIndexedFormParams)this.injector.getInstance(BindResourceIdsToIndexedFormParams.class);

    public void test() {
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        request = this.binder.bindToRequest(request, (Object)ImmutableList.builder().add((Object)"alpha").add((Object)"omega").build());
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)"ResourceId.1=alpha&ResourceId.2=omega");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeArray() {
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        this.binder.bindToRequest(request, (Object)new File("foo"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullIsBad() {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        this.binder.bindToRequest(request, null);
    }
}

