/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.binders;

import java.io.IOException;
import org.jclouds.ec2.binders.BindS3UploadPolicyAndSignature;
import org.jclouds.ec2.services.BaseEC2AsyncClientTest;
import org.jclouds.ec2.services.InstanceAsyncClient;
import org.jclouds.http.HttpRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BindS3UploadPolicyAndSignatureTest")
public class BindS3UploadPolicyAndSignatureTest
extends BaseEC2AsyncClientTest<InstanceAsyncClient> {
    private BindS3UploadPolicyAndSignature binder;

    @Override
    @BeforeClass
    protected void setupFactory() throws IOException {
        super.setupFactory();
        this.binder = (BindS3UploadPolicyAndSignature)this.injector.getInstance(BindS3UploadPolicyAndSignature.class);
    }

    public void testMapping() {
        String json = "{\"foo\":true}";
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        request = this.binder.bindToRequest(request, (Object)json);
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)"Storage.S3.UploadPolicy=eyJmb28iOnRydWV9&Storage.S3.UploadPolicySignature=UbDQLDM5P3aZ840aqJoH%2B6rwDcRo5KrIfsG7vJWHIVY%3D");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullIsBad() {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        this.binder.bindToRequest(request, null);
    }
}

