/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.binders;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import org.jclouds.ec2.binders.BindUserIdGroupPairToSourceSecurityGroupFormParams;
import org.jclouds.ec2.domain.UserIdGroupPair;
import org.jclouds.http.HttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindUserIdGroupPairToSourceSecurityGroupFormParamsTest {
    Injector injector = Guice.createInjector((Module[])new Module[0]);
    BindUserIdGroupPairToSourceSecurityGroupFormParams binder = (BindUserIdGroupPairToSourceSecurityGroupFormParams)this.injector.getInstance(BindUserIdGroupPairToSourceSecurityGroupFormParams.class);

    public void testUserIdGroupPair() {
        UserIdGroupPair pair = new UserIdGroupPair("id", "group");
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        request = this.binder.bindToRequest(request, (Object)pair);
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)"SourceSecurityGroupOwnerId=id&SourceSecurityGroupName=group");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeUserIdGroupPair() {
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        this.binder.bindToRequest(request, (Object)new File("foo"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullIsBad() {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        this.binder.bindToRequest(request, null);
    }
}

