/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.net.HostAndPort;
import com.google.inject.Module;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilderSpec;
import org.jclouds.compute.internal.BaseComputeServiceLiveTest;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.EC2ApiMetadata;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.ec2.domain.IpProtocol;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.domain.PublicIpInstanceIdPair;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.ec2.domain.Snapshot;
import org.jclouds.ec2.domain.Volume;
import org.jclouds.ec2.options.CreateSnapshotOptions;
import org.jclouds.ec2.services.ElasticBlockStoreClient;
import org.jclouds.ec2.services.InstanceClient;
import org.jclouds.ec2.services.KeyPairClient;
import org.jclouds.ec2.services.SecurityGroupClient;
import org.jclouds.rest.RestContext;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.jclouds.util.InetAddresses2;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true)
public class EC2ComputeServiceLiveTest
extends BaseComputeServiceLiveTest {
    protected TemplateBuilderSpec ebsTemplate;

    public EC2ComputeServiceLiveTest() {
        this.provider = "ec2";
    }

    protected Module getSshModule() {
        return new SshjSshClientModule();
    }

    protected void checkUserMetadataContains(NodeMetadata node, ImmutableMap<String, String> userMetadata) {
        if (((EC2Client)((RestContext)((ComputeServiceContext)this.view).unwrap(EC2ApiMetadata.CONTEXT_TOKEN)).getApi()).getTagApi().isPresent()) {
            super.checkUserMetadataContains(node, userMetadata);
        } else {
            Assert.assertTrue((boolean)node.getUserMetadata().isEmpty(), (String)("not expecting metadata when tag extension isn't present" + node));
        }
    }

    @Test(enabled=true, dependsOnMethods={"testCorrectAuthException"})
    public void testImagesResolveCorrectly() {
        Template defaultTemplate = this.client.templateBuilder().build();
        Assert.assertEquals((String)defaultTemplate.getImage().getId(), (String)(defaultTemplate.getImage().getLocation().getId() + "/" + defaultTemplate.getImage().getProviderId()));
        Template byId = this.client.templateBuilder().imageId(defaultTemplate.getImage().getId()).build();
        Assert.assertEquals((Object)byId.getImage(), (Object)defaultTemplate.getImage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true, dependsOnMethods={"testCompareSizes"})
    public void testExtendedOptionsAndLogin() throws Exception {
        SecurityGroupClient securityGroupClient = ((EC2Client)EC2Client.class.cast(((RestContext)((ComputeServiceContext)this.view).unwrap(EC2ApiMetadata.CONTEXT_TOKEN)).getApi())).getSecurityGroupServices();
        KeyPairClient keyPairClient = ((EC2Client)EC2Client.class.cast(((RestContext)((ComputeServiceContext)this.view).unwrap(EC2ApiMetadata.CONTEXT_TOKEN)).getApi())).getKeyPairServices();
        InstanceClient instanceClient = ((EC2Client)EC2Client.class.cast(((RestContext)((ComputeServiceContext)this.view).unwrap(EC2ApiMetadata.CONTEXT_TOKEN)).getApi())).getInstanceServices();
        String group = this.group + "o";
        TemplateOptions options = this.client.templateOptions();
        ((EC2TemplateOptions)options.as(EC2TemplateOptions.class)).securityGroups(new String[]{group});
        String startedId = null;
        try {
            EC2ComputeServiceLiveTest.cleanupExtendedStuffInRegion(null, securityGroupClient, keyPairClient, group);
            securityGroupClient.createSecurityGroupInRegion(null, group, group);
            securityGroupClient.authorizeSecurityGroupIngressInRegion(null, group, IpProtocol.TCP, 22, 22, "0.0.0.0/0");
            KeyPair result = keyPairClient.createKeyPairInRegion(null, group);
            ((EC2TemplateOptions)options.as(EC2TemplateOptions.class)).keyPair(result.getKeyName());
            assert (result.getKeyMaterial() != null) : result;
            options.overrideLoginPrivateKey(result.getKeyMaterial());
            options.runScript(Statements.exec((String)"find /usr"));
            Set nodes = this.client.createNodesInGroup(group, 1, options);
            NodeMetadata first = (NodeMetadata)Iterables.get((Iterable)nodes, (int)0);
            assert (first.getCredentials() != null) : first;
            assert (first.getCredentials().identity != null) : first;
            startedId = ((NodeMetadata)Iterables.getOnlyElement((Iterable)nodes)).getProviderId();
            RunningInstance instance = EC2ComputeServiceLiveTest.getInstance(instanceClient, startedId);
            Assert.assertEquals((String)instance.getKeyName(), (String)group);
            Assert.assertEquals((Set)Sets.newTreeSet((Iterable)instance.getGroupNames()), (Set)ImmutableSortedSet.of((Comparable)((Object)("jclouds#" + group + "#" + instance.getRegion())), (Comparable)((Object)group)));
            SecurityGroup secgroup = (SecurityGroup)Iterables.getOnlyElement((Iterable)securityGroupClient.describeSecurityGroupsInRegion(null, new String[]{"jclouds#" + group + "#" + instance.getRegion()}));
            assert (secgroup.size() == 0) : secgroup;
            this.runScriptWithCreds(group, first.getOperatingSystem(), LoginCredentials.builder().user(first.getCredentials().identity).privateKey(result.getKeyMaterial()).build());
        }
        catch (Throwable throwable) {
            this.client.destroyNodesMatching(NodePredicates.inGroup((String)group));
            if (startedId != null) {
                Assert.assertEquals((int)keyPairClient.describeKeyPairsInRegion(null, new String[]{group}).size(), (int)1);
                Assert.assertEquals((int)securityGroupClient.describeSecurityGroupsInRegion(null, new String[]{group}).size(), (int)1);
            }
            EC2ComputeServiceLiveTest.cleanupExtendedStuffInRegion(null, securityGroupClient, keyPairClient, group);
            throw throwable;
        }
        this.client.destroyNodesMatching(NodePredicates.inGroup((String)group));
        if (startedId != null) {
            Assert.assertEquals((int)keyPairClient.describeKeyPairsInRegion(null, new String[]{group}).size(), (int)1);
            Assert.assertEquals((int)securityGroupClient.describeSecurityGroupsInRegion(null, new String[]{group}).size(), (int)1);
        }
        EC2ComputeServiceLiveTest.cleanupExtendedStuffInRegion(null, securityGroupClient, keyPairClient, group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testAutoIpAllocation() throws Exception {
        ComputeServiceContext context = null;
        String group = this.group + "aip";
        try {
            Properties overrides = this.setupProperties();
            overrides.setProperty("jclouds.ec2.auto-allocate-elastic-ips", "true");
            context = (ComputeServiceContext)this.createView(overrides, this.setupModules());
            Set nodes = context.getComputeService().createNodesInGroup(group, 1);
            Assert.assertEquals((int)nodes.size(), (int)1, (String)"One node should have been created");
            NodeMetadata node = (NodeMetadata)Iterables.get((Iterable)nodes, (int)0);
            String region = node.getLocation().getParent().getId();
            Set publicIps = node.getPublicAddresses();
            Assert.assertFalse((boolean)Iterables.isEmpty((Iterable)publicIps), (String)String.format("no public addresses attached to node %s", node));
            Assert.assertEquals((int)Iterables.size((Iterable)publicIps), (int)1);
            String ip = (String)Iterables.getOnlyElement((Iterable)publicIps);
            Assert.assertFalse((boolean)InetAddresses2.isPrivateIPAddress((String)ip));
            HostAndPort socket = HostAndPort.fromParts((String)ip, (int)22);
            Assert.assertTrue((boolean)this.socketTester.apply((Object)socket), (String)String.format("failed to open socket %s on node %s", socket, node));
            EC2Client ec2 = (EC2Client)EC2Client.class.cast(((RestContext)context.unwrap(EC2ApiMetadata.CONTEXT_TOKEN)).getApi());
            Set ipidpairs = ec2.getElasticIPAddressServices().describeAddressesInRegion(region, publicIps.toArray(new String[0]));
            Assert.assertEquals((int)ipidpairs.size(), (int)1, (String)String.format("there should only be one address pair (%s)", Iterables.toString((Iterable)ipidpairs)));
            PublicIpInstanceIdPair ipidpair = (PublicIpInstanceIdPair)Iterables.get((Iterable)ipidpairs, (int)0);
            Assert.assertEquals((String)(region + "/" + ipidpair.getInstanceId()), (String)node.getId());
            context.getComputeService().destroyNodesMatching(NodePredicates.inGroup((String)group));
            Set ipidcheck = ec2.getElasticIPAddressServices().describeAddressesInRegion(region, new String[]{ipidpair.getPublicIp()});
            Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)ipidcheck), (String)String.format("there should be no address pairs (%s)", Iterables.toString((Iterable)ipidcheck)));
        }
        finally {
            context.getComputeService().destroyNodesMatching(NodePredicates.inGroup((String)group));
            if (context != null) {
                context.close();
            }
        }
    }

    protected Properties setupProperties() {
        Properties overrides = super.setupProperties();
        String ebsSpec = this.setIfTestSystemPropertyPresent(overrides, this.provider + ".ebs-template");
        if (ebsSpec != null) {
            this.ebsTemplate = TemplateBuilderSpec.parse((String)ebsSpec);
        }
        return overrides;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMapEBS() throws Exception {
        if (this.ebsTemplate == null) {
            throw new SkipException("Test cannot run without the parameter test." + this.provider + ".ebs-template; this property should be in the format defined in TemplateBuilderSpec");
        }
        InstanceClient instanceClient = ((EC2Client)EC2Client.class.cast(((RestContext)((ComputeServiceContext)this.view).unwrap(EC2ApiMetadata.CONTEXT_TOKEN)).getApi())).getInstanceServices();
        ElasticBlockStoreClient ebsClient = ((EC2Client)EC2Client.class.cast(((RestContext)((ComputeServiceContext)this.view).unwrap(EC2ApiMetadata.CONTEXT_TOKEN)).getApi())).getElasticBlockStoreServices();
        String group = this.group + "e";
        int volumeSize = 8;
        final Template template = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().from(this.ebsTemplate).build();
        Location zone = (Location)Iterables.find((Iterable)((ComputeServiceContext)this.view).getComputeService().listAssignableLocations(), (Predicate)new Predicate<Location>(){

            public boolean apply(Location arg0) {
                return arg0.getScope() == LocationScope.ZONE && arg0.getParent().getId().equals(template.getLocation().getId());
            }
        });
        Volume volume = ebsClient.createVolumeInAvailabilityZone(zone.getId(), 4);
        Snapshot snapshot = ebsClient.createSnapshotInRegion(volume.getRegion(), volume.getId(), new CreateSnapshotOptions[0]);
        ebsClient.deleteVolumeInRegion(volume.getRegion(), volume.getId());
        ((EC2TemplateOptions)template.getOptions().as(EC2TemplateOptions.class)).mapEphemeralDeviceToDeviceName("/dev/sdm", "ephemeral0").mapNewVolumeToDeviceName("/dev/sdn", volumeSize, true).mapEBSSnapshotToDeviceName("/dev/sdo", snapshot.getId(), Integer.valueOf(volumeSize), true);
        try {
            NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)this.client.createNodesInGroup(group, 1, template));
            Map devices = instanceClient.getBlockDeviceMappingForInstanceInRegion(node.getLocation().getParent().getId(), node.getProviderId());
            BlockDevice device = (BlockDevice)devices.get("/dev/sdn");
            Assert.assertTrue((boolean)device.isDeleteOnTermination());
            volume = (Volume)Iterables.getOnlyElement((Iterable)ebsClient.describeVolumesInRegion(node.getLocation().getParent().getId(), new String[]{device.getVolumeId()}));
            Assert.assertEquals((int)volumeSize, (int)volume.getSize());
            device = (BlockDevice)devices.get("/dev/sdo");
            Assert.assertTrue((boolean)device.isDeleteOnTermination());
            volume = (Volume)Iterables.getOnlyElement((Iterable)ebsClient.describeVolumesInRegion(node.getLocation().getParent().getId(), new String[]{device.getVolumeId()}));
            Assert.assertEquals((int)volumeSize, (int)volume.getSize());
            Assert.assertEquals((String)snapshot.getId(), (String)volume.getSnapshotId());
        }
        finally {
            this.client.destroyNodesMatching(NodePredicates.inGroup((String)group));
            ebsClient.deleteSnapshotInRegion(snapshot.getRegion(), snapshot.getId());
        }
    }

    public static RunningInstance getInstance(InstanceClient instanceClient, String id) {
        RunningInstance instance = (RunningInstance)Iterables.getOnlyElement((Iterable)((Iterable)Iterables.getOnlyElement((Iterable)instanceClient.describeInstancesInRegion(null, new String[]{id}))));
        return instance;
    }

    protected static void cleanupExtendedStuffInRegion(String region, SecurityGroupClient securityGroupClient, KeyPairClient keyPairClient, String group) throws InterruptedException {
        try {
            for (SecurityGroup secgroup : securityGroupClient.describeSecurityGroupsInRegion(region, new String[0])) {
                if (!secgroup.getName().startsWith("jclouds#" + group) && !secgroup.getName().equals(group)) continue;
                securityGroupClient.deleteSecurityGroupInRegion(region, secgroup.getName());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            for (KeyPair pair : keyPairClient.describeKeyPairsInRegion(region, new String[0])) {
                if (!pair.getKeyName().startsWith("jclouds#" + group) && !pair.getKeyName().equals(group)) continue;
                keyPairClient.deleteKeyPairInRegion(region, pair.getKeyName());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Thread.sleep(2000L);
    }
}

