/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.config;

import com.google.common.base.Supplier;
import com.google.common.cache.CacheLoader;
import org.easymock.EasyMock;
import org.jclouds.compute.domain.Image;
import org.jclouds.ec2.compute.config.EC2ComputeServiceContextModule;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.loaders.RegionAndIdToImage;
import org.jclouds.rest.AuthorizationException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class EC2ComputeServiceContextModuleTest {
    @Test
    public void testCacheLoaderDoesNotReloadAfterAuthorizationException() throws Exception {
        EC2ComputeServiceContextModule module = new EC2ComputeServiceContextModule(){

            public Supplier<CacheLoader<RegionAndName, Image>> provideRegionAndNameToImageSupplierCacheLoader(RegionAndIdToImage delegate) {
                return super.provideRegionAndNameToImageSupplierCacheLoader(delegate);
            }
        };
        RegionAndName regionAndName = new RegionAndName("myregion", "myname");
        AuthorizationException authException = new AuthorizationException();
        RegionAndIdToImage mockRegionAndIdToImage = (RegionAndIdToImage)EasyMock.createMock(RegionAndIdToImage.class);
        EasyMock.expect((Object)mockRegionAndIdToImage.load(regionAndName)).andThrow((Throwable)authException).once();
        EasyMock.replay((Object[])new Object[]{mockRegionAndIdToImage});
        CacheLoader cacheLoader = (CacheLoader)module.provideRegionAndNameToImageSupplierCacheLoader(mockRegionAndIdToImage).get();
        for (int i = 0; i < 2; ++i) {
            try {
                Image image = (Image)cacheLoader.load((Object)regionAndName);
                Assert.fail((String)("Expected Authorization exception, but got " + image));
                continue;
            }
            catch (AuthorizationException e) {
                // empty catch block
            }
        }
    }
}

