/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.config.BaseComputeServiceContextModule;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.compute.config.EC2ComputeServiceDependenciesModule;
import org.jclouds.ec2.compute.functions.EC2ImageParser;
import org.jclouds.ec2.compute.strategy.EC2PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.ec2.compute.strategy.ReviseParsedImage;
import org.jclouds.ec2.xml.DescribeImagesResponseHandlerTest;
import org.jclouds.json.Json;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="EC2ImageParserTest")
public class EC2ImageParserTest {
    static Location defaultLocation = new LocationBuilder().scope(LocationScope.REGION).id("us-east-1").description("us-east-1").build();

    public void testParseAmznImage() {
        Set<Image> result = EC2ImageParserTest.convertImages("/amzn_images.xml");
        for (Image image : result) {
            Assert.assertEquals((Object)image.getStatus(), (Object)Image.Status.AVAILABLE);
            Assert.assertEquals((String)image.getBackendStatus(), (String)"available");
        }
        this.assertImageEquals((Image)Iterables.get(result, (int)0), new ImageBuilder().operatingSystem(new OperatingSystem.Builder().family(OsFamily.UNRECOGNIZED).arch("paravirtual").version("").description("137112412989/amzn-ami-0.9.7-beta.i386-ebs").is64Bit(false).build()).description("Amazon").defaultCredentials(LoginCredentials.builder().user("ec2-user").build()).id("us-east-1/ami-82e4b5c7").name("amzn-ami-0.9.7-beta.i386-ebs").providerId("ami-82e4b5c7").location(defaultLocation).userMetadata((Map)ImmutableMap.of((Object)"owner", (Object)"137112412989", (Object)"rootDeviceType", (Object)"ebs")).status(Image.Status.AVAILABLE).backendStatus("available").build());
        this.assertImageEquals((Image)Iterables.get(result, (int)3), new ImageBuilder().operatingSystem(new OperatingSystem.Builder().family(OsFamily.UNRECOGNIZED).arch("paravirtual").version("").description("amzn-ami-us-west-1/amzn-ami-0.9.7-beta.x86_64.manifest.xml").is64Bit(true).build()).description("Amazon Linux AMI x86_64 S3").defaultCredentials(LoginCredentials.builder().user("ec2-user").build()).id("us-east-1/ami-f2e4b5b7").providerId("ami-f2e4b5b7").name("amzn-ami-0.9.7-beta.x86_64-S3").location(defaultLocation).userMetadata((Map)ImmutableMap.of((Object)"owner", (Object)"137112412989", (Object)"rootDeviceType", (Object)"ebs")).status(Image.Status.AVAILABLE).backendStatus("available").build());
        this.assertImageEquals((Image)Iterables.get(result, (int)4), new ImageBuilder().operatingSystem(new OperatingSystem.Builder().family(OsFamily.WINDOWS).arch("hvm").version("2008").description("amazon/NameGivesNoClue_Server-2008-R2_SP1-Language_Packs-64Bit-Base-2012.05.10").is64Bit(true).build()).description("Microsoft Windows Server 2008 R2 SP1 Datacenter 64-bit Multi-language AMI provided by Amazon").defaultCredentials(LoginCredentials.builder().user("root").build()).id("us-east-1/ami-85457ff1").providerId("ami-85457ff1").name("NameGivesNoClue_Server-2008-R2_SP1-Language_Packs-64Bit-Base-2012.05.10").location(defaultLocation).userMetadata((Map)ImmutableMap.of((Object)"owner", (Object)"801119661308", (Object)"rootDeviceType", (Object)"ebs")).status(Image.Status.AVAILABLE).backendStatus("available").build());
    }

    private void assertImageEquals(Image actual, Image expected) {
        Assert.assertEquals((Object)actual, (Object)expected);
        Assert.assertEquals((Object)actual.getOperatingSystem(), (Object)expected.getOperatingSystem());
        Assert.assertEquals((Object)actual.getStatus(), (Object)expected.getStatus());
        Assert.assertEquals((String)actual.getBackendStatus(), (String)expected.getBackendStatus());
        Assert.assertEquals((String)actual.getVersion(), (String)expected.getVersion());
        Assert.assertEquals((String)actual.getDescription(), (String)expected.getDescription());
        Assert.assertEquals((Object)actual.getDefaultCredentials(), (Object)expected.getDefaultCredentials());
    }

    public static Set<Image> convertImages(String resource) {
        Map map = new BaseComputeServiceContextModule(){}.provideOsVersionMap(new ComputeServiceConstants.ReferenceData(), (Json)Guice.createInjector((Module[])new Module[]{new GsonModule()}).getInstance(Json.class));
        Set<org.jclouds.ec2.domain.Image> result = DescribeImagesResponseHandlerTest.parseImages(resource);
        EC2ImageParser parser = new EC2ImageParser(EC2ComputeServiceDependenciesModule.toPortableImageStatus, (PopulateDefaultLoginCredentialsForImageStrategy)new EC2PopulateDefaultLoginCredentialsForImageStrategy(), map, Suppliers.ofInstance((Object)ImmutableSet.of((Object)defaultLocation)), Suppliers.ofInstance((Object)defaultLocation), (ReviseParsedImage)new ReviseParsedImage.NoopReviseParsedImage());
        return Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)Iterables.transform(result, (Function)parser), (Predicate)Predicates.notNull()));
    }
}

