/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.functions;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Module;
import java.util.Properties;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilderSpec;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.encryption.bouncycastle.config.BouncyCastleCryptoModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="PasswordCredentialsFromWindowsInstanceLiveTest")
public class PasswordCredentialsFromWindowsInstanceLiveTest
extends BaseComputeServiceContextLiveTest {
    protected TemplateBuilderSpec windowsTemplate;

    public PasswordCredentialsFromWindowsInstanceLiveTest() {
        this.provider = "ec2";
    }

    protected Properties setupProperties() {
        String windowsOwner;
        Properties overrides = super.setupProperties();
        String windowsSpec = this.setIfTestSystemPropertyPresent(overrides, this.provider + ".windows-template");
        if (Strings.emptyToNull((String)windowsSpec) != null) {
            this.windowsTemplate = TemplateBuilderSpec.parse((String)windowsSpec);
        }
        if (Strings.emptyToNull((String)(windowsOwner = this.setIfTestSystemPropertyPresent(overrides, this.provider + ".windows-owner"))) != null) {
            overrides.setProperty("jclouds.ec2.ami-owners", windowsOwner);
        }
        return overrides;
    }

    protected Iterable<Module> setupModules() {
        return ImmutableSet.builder().addAll(super.setupModules()).add((Object)new BouncyCastleCryptoModule()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWindowsAdminWorks() throws Exception {
        String group = "winadm";
        Template template = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().from(this.windowsTemplate).options(TemplateOptions.Builder.inboundPorts((int[])new int[]{3389})).build();
        try {
            NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)((ComputeServiceContext)this.view).getComputeService().createNodesInGroup(group, 1, template));
            Assert.assertEquals((String)node.getCredentials().getUser(), (String)"Administrator");
            Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)node.getCredentials().getPassword()));
        }
        finally {
            ((ComputeServiceContext)this.view).getComputeService().destroyNodesMatching(NodePredicates.inGroup((String)group));
        }
    }
}

