/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.functions;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.EC2ApiMetadata;
import org.jclouds.ec2.compute.config.EC2ComputeServiceDependenciesModule;
import org.jclouds.ec2.compute.domain.EC2HardwareBuilder;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.EC2ImageParserTest;
import org.jclouds.ec2.compute.functions.ImagesToRegionAndIdMap;
import org.jclouds.ec2.compute.functions.RunningInstanceToNodeMetadata;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.xml.DescribeInstancesResponseHandlerTest;
import org.jclouds.javax.annotation.Nullable;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RunningInstanceToNodeMetadataTest")
public class RunningInstanceToNodeMetadataTest {
    static Location provider = new LocationBuilder().scope(LocationScope.REGION).id("us-east-1").description("us-east-1").build();

    public void testAllStatesCovered() {
        for (InstanceState status : InstanceState.values()) {
            assert (EC2ComputeServiceDependenciesModule.toPortableNodeStatus.containsKey(status)) : status;
        }
    }

    @Test
    public void testPrivateIpAddressIncorrectlyInPublicAddressFieldGoesToPrivateAddressCollection() {
        RunningInstance instance = RunningInstance.builder().instanceId("id").imageId("image").instanceType("m1.small").instanceState(InstanceState.RUNNING).rawState("running").region("us-east-1").ipAddress("10.1.1.1").build();
        RunningInstanceToNodeMetadata parser = this.createNodeParser((ImmutableSet<Hardware>)ImmutableSet.of(), (ImmutableSet<Location>)ImmutableSet.of(), (Set<Image>)ImmutableSet.of(), (Map<String, Credentials>)ImmutableMap.of());
        Assert.assertEquals((String)parser.apply(instance).toString(), (String)new NodeMetadataBuilder().status(NodeMetadata.Status.RUNNING).backendStatus("running").publicAddresses((Iterable)ImmutableSet.of()).privateAddresses((Iterable)ImmutableSet.of((Object)"10.1.1.1")).id("us-east-1/id").imageId("us-east-1/image").providerId("id").build().toString());
    }

    @Test
    public void testPublicIpAddressIncorrectlyInPrivateAddressFieldGoesToPublicAddressCollection() {
        RunningInstance instance = RunningInstance.builder().instanceId("id").imageId("image").instanceType("m1.small").instanceState(InstanceState.RUNNING).rawState("running").region("us-east-1").privateIpAddress("1.1.1.1").build();
        RunningInstanceToNodeMetadata parser = this.createNodeParser((ImmutableSet<Hardware>)ImmutableSet.of(), (ImmutableSet<Location>)ImmutableSet.of(), (Set<Image>)ImmutableSet.of(), (Map<String, Credentials>)ImmutableMap.of());
        Assert.assertEquals((String)parser.apply(instance).toString(), (String)new NodeMetadataBuilder().status(NodeMetadata.Status.RUNNING).backendStatus("running").privateAddresses((Iterable)ImmutableSet.of()).publicAddresses((Iterable)ImmutableSet.of((Object)"1.1.1.1")).id("us-east-1/id").imageId("us-east-1/image").providerId("id").build().toString());
    }

    @Test
    public void testApplyWhereTagDoesntMatchAndImageHardwareAndLocationNotFoundButCredentialsFound() throws UnknownHostException {
        LoginCredentials creds = LoginCredentials.builder().user("root").password("abdce").build();
        RunningInstanceToNodeMetadata parser = this.createNodeParser((ImmutableSet<Hardware>)ImmutableSet.of(), (ImmutableSet<Location>)ImmutableSet.of(), (Set<Image>)ImmutableSet.of(), (Map<String, Credentials>)ImmutableMap.of((Object)"node#us-east-1/i-0799056f", (Object)creds));
        RunningInstance server = this.firstInstanceFromResource("/describe_instances_running.xml");
        Assert.assertEquals((String)parser.apply(server).toString(), (String)new NodeMetadataBuilder().status(NodeMetadata.Status.RUNNING).backendStatus("running").hostname("ip-10-243-42-70").publicAddresses((Iterable)ImmutableSet.of()).privateAddresses((Iterable)ImmutableSet.of((Object)"10.243.42.70")).publicAddresses((Iterable)ImmutableSet.of((Object)"174.129.81.68")).credentials(creds).imageId("us-east-1/ami-82e4b5c7").id("us-east-1/i-0799056f").providerId("i-0799056f").build().toString());
    }

    @Test
    public void testApplyWhereTagDoesntMatchAndImageHardwareAndLocationNotFound() throws UnknownHostException {
        RunningInstanceToNodeMetadata parser = this.createNodeParser((ImmutableSet<Hardware>)ImmutableSet.of(), (ImmutableSet<Location>)ImmutableSet.of(), (Set<Image>)ImmutableSet.of(), (Map<String, Credentials>)ImmutableMap.of());
        RunningInstance server = this.firstInstanceFromResource("/describe_instances_running.xml");
        Assert.assertEquals((String)parser.apply(server).toString(), (String)new NodeMetadataBuilder().hostname("ip-10-243-42-70").status(NodeMetadata.Status.RUNNING).backendStatus("running").publicAddresses((Iterable)ImmutableSet.of()).privateAddresses((Iterable)ImmutableSet.of((Object)"10.243.42.70")).publicAddresses((Iterable)ImmutableSet.of((Object)"174.129.81.68")).imageId("us-east-1/ami-82e4b5c7").id("us-east-1/i-0799056f").providerId("i-0799056f").build().toString());
    }

    @Test
    public void testApplyWhereTagDoesntMatchAndLocationFoundAndImageAndHardwareNotFound() throws UnknownHostException {
        RunningInstanceToNodeMetadata parser = this.createNodeParser((ImmutableSet<Hardware>)ImmutableSet.of(), (ImmutableSet<Location>)ImmutableSet.of((Object)provider), (Set<Image>)ImmutableSet.of(), (Map<String, Credentials>)ImmutableMap.of());
        RunningInstance server = this.firstInstanceFromResource("/describe_instances_running.xml");
        NodeMetadata expected = new NodeMetadataBuilder().hostname("ip-10-243-42-70").status(NodeMetadata.Status.RUNNING).backendStatus("running").privateAddresses((Iterable)ImmutableSet.of((Object)"10.243.42.70")).publicAddresses((Iterable)ImmutableSet.of((Object)"174.129.81.68")).imageId("us-east-1/ami-82e4b5c7").id("us-east-1/i-0799056f").providerId("i-0799056f").location(provider).build();
        Assert.assertEquals((String)parser.apply(server).toString(), (String)expected.toString());
    }

    @Test
    public void testApplyWhereTagDoesntMatchAndImageAndLocationFoundAndHardwareNotFound() throws UnknownHostException {
        RunningInstanceToNodeMetadata parser = this.createNodeParser((ImmutableSet<Hardware>)ImmutableSet.of(), (ImmutableSet<Location>)ImmutableSet.of((Object)provider), EC2ImageParserTest.convertImages("/amzn_images.xml"), (Map<String, Credentials>)ImmutableMap.of());
        RunningInstance server = this.firstInstanceFromResource("/describe_instances_running.xml");
        Assert.assertEquals((String)parser.apply(server).toString(), (String)new NodeMetadataBuilder().status(NodeMetadata.Status.RUNNING).backendStatus("running").hostname("ip-10-243-42-70").privateAddresses((Iterable)ImmutableSet.of((Object)"10.243.42.70")).publicAddresses((Iterable)ImmutableSet.of((Object)"174.129.81.68")).imageId("us-east-1/ami-82e4b5c7").operatingSystem(new OperatingSystem.Builder().family(OsFamily.UNRECOGNIZED).version("").arch("paravirtual").description("137112412989/amzn-ami-0.9.7-beta.i386-ebs").is64Bit(false).build()).id("us-east-1/i-0799056f").providerId("i-0799056f").location(provider).build().toString());
    }

    @Test
    public void testApplyWhereTagDoesntMatchAndImageHardwareAndLocationFound() throws UnknownHostException {
        RunningInstanceToNodeMetadata parser = this.createNodeParser((ImmutableSet<Hardware>)ImmutableSet.of((Object)EC2HardwareBuilder.m1_small().build()), (ImmutableSet<Location>)ImmutableSet.of((Object)provider), EC2ImageParserTest.convertImages("/amzn_images.xml"), (Map<String, Credentials>)ImmutableMap.of());
        RunningInstance server = this.firstInstanceFromResource("/describe_instances_running.xml");
        Assert.assertEquals((String)parser.apply(server).toString(), (String)new NodeMetadataBuilder().hostname("ip-10-243-42-70").status(NodeMetadata.Status.RUNNING).backendStatus("running").privateAddresses((Iterable)ImmutableSet.of((Object)"10.243.42.70")).publicAddresses((Iterable)ImmutableSet.of((Object)"174.129.81.68")).imageId("us-east-1/ami-82e4b5c7").hardware(EC2HardwareBuilder.m1_small().build()).operatingSystem(new OperatingSystem.Builder().family(OsFamily.UNRECOGNIZED).version("").arch("paravirtual").description("137112412989/amzn-ami-0.9.7-beta.i386-ebs").is64Bit(false).build()).id("us-east-1/i-0799056f").providerId("i-0799056f").location(provider).build().toString());
    }

    @Test
    public void testHandleMissingAMIs() {
        CacheLoader<RegionAndName, Image> nullReturningFunction = new CacheLoader<RegionAndName, Image>(){

            public Image load(@Nullable RegionAndName from) {
                return null;
            }
        };
        LoadingCache instanceToImage = CacheBuilder.newBuilder().build((CacheLoader)nullReturningFunction);
        RunningInstanceToNodeMetadata parser = this.createNodeParser((ImmutableSet<Hardware>)ImmutableSet.of((Object)EC2HardwareBuilder.m1_small().build()), (ImmutableSet<Location>)ImmutableSet.of((Object)provider), (Map<String, Credentials>)ImmutableMap.of(), EC2ComputeServiceDependenciesModule.toPortableNodeStatus, (LoadingCache<RegionAndName, Image>)instanceToImage);
        RunningInstance server = this.firstInstanceFromResource("/describe_instances_running.xml");
        Assert.assertEquals((String)parser.apply(server).toString(), (String)new NodeMetadataBuilder().hostname("ip-10-243-42-70").status(NodeMetadata.Status.RUNNING).backendStatus("running").privateAddresses((Iterable)ImmutableSet.of((Object)"10.243.42.70")).publicAddresses((Iterable)ImmutableSet.of((Object)"174.129.81.68")).imageId("us-east-1/ami-82e4b5c7").id("us-east-1/i-0799056f").providerId("i-0799056f").hardware(EC2HardwareBuilder.m1_small().build()).location(provider).build().toString());
    }

    @Test
    public void testGroupNameIsSetWhenCustomKeyNameIsSetAndSecurityGroupIsGenerated() {
        this.checkGroupName(RunningInstance.builder().instanceId("id").imageId("image").instanceType("m1.small").instanceState(InstanceState.RUNNING).rawState("running").region("us-east-1").keyName("custom-key").groupName("jclouds#groupname").build());
    }

    @Test
    public void testGroupNameIsSetWhenCustomSecurityGroupIsSetAndKeyNameIsGenerated() {
        this.checkGroupName(RunningInstance.builder().instanceId("id").imageId("image").instanceType("m1.small").instanceState(InstanceState.RUNNING).rawState("running").region("us-east-1").groupName("custom-sec").keyName("jclouds#groupname#23").build());
    }

    protected RunningInstance firstInstanceFromResource(String resource) {
        return (RunningInstance)Iterables.get((Iterable)((Iterable)Iterables.get(DescribeInstancesResponseHandlerTest.parseRunningInstances(resource), (int)0)), (int)0);
    }

    protected RunningInstanceToNodeMetadata createNodeParser(ImmutableSet<Hardware> hardware, ImmutableSet<Location> locations, final Set<Image> images, Map<String, Credentials> credentialStore) {
        Map instanceToNodeStatus = EC2ComputeServiceDependenciesModule.toPortableNodeStatus;
        CacheLoader<RegionAndName, Image> getRealImage = new CacheLoader<RegionAndName, Image>(){

            public Image load(@Nullable RegionAndName from) {
                return (Image)ImagesToRegionAndIdMap.imagesToMap((Iterable)images).get(from);
            }
        };
        LoadingCache instanceToImage = CacheBuilder.newBuilder().build((CacheLoader)getRealImage);
        return this.createNodeParser(hardware, locations, credentialStore, instanceToNodeStatus, (LoadingCache<RegionAndName, Image>)instanceToImage);
    }

    private void checkGroupName(RunningInstance instance) {
        Assert.assertEquals((String)"groupname", (String)this.createNodeParser((ImmutableSet<Hardware>)ImmutableSet.of(), (ImmutableSet<Location>)ImmutableSet.of(), (Set<Image>)ImmutableSet.of(), (Map<String, Credentials>)ImmutableMap.of()).apply(instance).getGroup());
    }

    private RunningInstanceToNodeMetadata createNodeParser(final ImmutableSet<Hardware> hardware, final ImmutableSet<Location> locations, Map<String, Credentials> credentialStore, Map<InstanceState, NodeMetadata.Status> instanceToNodeStatus, LoadingCache<RegionAndName, Image> instanceToImage) {
        Supplier<Set<? extends Location>> locationSupplier = new Supplier<Set<? extends Location>>(){

            public Set<? extends Location> get() {
                return locations;
            }
        };
        Supplier<Set<? extends Hardware>> hardwareSupplier = new Supplier<Set<? extends Hardware>>(){

            public Set<? extends Hardware> get() {
                return hardware;
            }
        };
        GroupNamingConvention.Factory namingConvention = (GroupNamingConvention.Factory)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                Names.bindProperties((Binder)this.binder(), (Properties)new EC2ApiMetadata().getDefaultProperties());
            }
        }}).getInstance(GroupNamingConvention.Factory.class);
        RunningInstanceToNodeMetadata parser = new RunningInstanceToNodeMetadata(instanceToNodeStatus, credentialStore, Suppliers.ofInstance(instanceToImage), (Supplier)locationSupplier, (Supplier)hardwareSupplier, namingConvention);
        return parser;
    }
}

